"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertAppendProcessorToESQL = convertAppendProcessorToESQL;
var _esqlAst = require("@kbn/esql-ast");
var _condition_to_esql = require("../condition_to_esql");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function convertAppendProcessorToESQL(processor) {
  const {
    to,
    value,
    // eslint-disable-next-line @typescript-eslint/naming-convention
    allow_duplicates = true,
    // default to true to match Append Ingest Processor
    where
  } = processor;
  const toColumn = _esqlAst.Builder.expression.column(to);
  const appendValueExpression = (0, _condition_to_esql.esqlLiteralFromAny)(value);
  let appendExpression = _esqlAst.Builder.expression.func.call('MV_APPEND', [toColumn, appendValueExpression]);
  if (!allow_duplicates) {
    appendExpression = _esqlAst.Builder.expression.func.call('MV_DEDUPE', [appendExpression]);
  }

  // If the target field is null, set it to the new value. Otherwise, append.
  let appendAssignment = _esqlAst.Builder.expression.func.call('CASE', [_esqlAst.Builder.expression.func.postfix('IS NULL', toColumn), appendValueExpression, appendExpression]);
  if (where) {
    const whereCondition = (0, _condition_to_esql.conditionToESQLAst)(where);
    appendAssignment = _esqlAst.Builder.expression.func.call('CASE', [whereCondition, appendAssignment, toColumn]);
  }
  return [_esqlAst.Builder.command({
    name: 'eval',
    args: [_esqlAst.Builder.expression.func.binary('=', [toColumn, appendAssignment])]
  })];
}