"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.XSOARConnector = exports.PLAYBOOKS_PATH = exports.INCIDENT_PATH = exports.CLOUD_API_PATH = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _server = require("@kbn/actions-plugin/server");
var _schema = require("../../../common/xsoar/schema");
var _constants = require("../../../common/xsoar/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CLOUD_API_PATH = exports.CLOUD_API_PATH = '/xsoar/public/v1';
const INCIDENT_PATH = exports.INCIDENT_PATH = '/incident';
const PLAYBOOKS_PATH = exports.PLAYBOOKS_PATH = '/playbook/search';
class XSOARConnector extends _server.SubActionConnector {
  constructor(params) {
    super(params);
    (0, _defineProperty2.default)(this, "urls", void 0);
    (0, _defineProperty2.default)(this, "isCloud", void 0);
    (0, _defineProperty2.default)(this, "ConnectorId", void 0);
    this.isCloud = this.secrets.apiKeyID !== null && this.secrets.apiKeyID !== '';
    this.urls = {
      playbooks: this.isCloud ? `${this.config.url}${CLOUD_API_PATH}${PLAYBOOKS_PATH}` : `${this.config.url}${PLAYBOOKS_PATH}`,
      incident: this.isCloud ? `${this.config.url}${CLOUD_API_PATH}${INCIDENT_PATH}` : `${this.config.url}${INCIDENT_PATH}`
    };
    this.ConnectorId = params.connector.id;
    this.registerSubActions();
  }
  registerSubActions() {
    this.registerSubAction({
      name: _constants.SUB_ACTION.PLAYBOOKS,
      method: 'getPlaybooks',
      schema: _schema.XSOARPlaybooksActionParamsSchema
    });
    this.registerSubAction({
      name: _constants.SUB_ACTION.RUN,
      method: 'run',
      schema: _schema.XSOARRunActionParamsSchema
    });
  }
  getAuthHeaders() {
    return this.isCloud ? {
      Authorization: this.secrets.apiKey,
      'x-xdr-auth-id': this.secrets.apiKeyID
    } : {
      Authorization: this.secrets.apiKey
    };
  }
  getResponseErrorMessage(error) {
    var _error$response;
    if ((_error$response = error.response) !== null && _error$response !== void 0 && _error$response.statusText) {
      var _error$response2;
      return `API Error: ${(_error$response2 = error.response) === null || _error$response2 === void 0 ? void 0 : _error$response2.statusText}`;
    }
    return error.toString();
  }
  formatIncidentBody(incident) {
    try {
      const {
        body,
        isRuleSeverity,
        ...incidentWithoutBody
      } = incident;
      const bodyJson = JSON.parse(body || '{}');
      const mergedIncident = {
        ...bodyJson,
        ...incidentWithoutBody
      };
      return mergedIncident;
    } catch (err) {
      const errMessage = _i18n.i18n.translate('xpack.stackConnectors.xsoar.BodyParsingErrorMessage', {
        defaultMessage: 'error triggering XSOAR workflow, parsing body'
      });
      this.logger.error(`error on ${this.ConnectorId} XSOAR event: ${errMessage}: ${err.message}`);
      throw new Error(_i18n.i18n.translate('xpack.stackConnectors.xsoar.incidentBodyParsingError', {
        defaultMessage: 'Error parsing Body: {err}',
        values: {
          err: err.toString()
        }
      }));
    }
  }
  async run(incident, connectorUsageCollector) {
    const mergedIncident = this.formatIncidentBody(incident);
    await this.request({
      method: 'post',
      url: `${this.urls.incident}`,
      data: mergedIncident,
      headers: this.getAuthHeaders(),
      responseSchema: _schema.XSOARRunActionResponseSchema
    }, connectorUsageCollector);
  }
  async getPlaybooks(params, connectorUsageCollector) {
    const res = await this.request({
      method: 'post',
      url: `${this.urls.playbooks}`,
      data: {},
      headers: this.getAuthHeaders(),
      responseSchema: _schema.XSOARPlaybooksActionResponseSchema,
      timeout: 15000
    }, connectorUsageCollector);
    return res.data;
  }
}
exports.XSOARConnector = XSOARConnector;