"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VISIT_SN_STORE = exports.USER_IDENTIFIER_REQUIRED = exports.USER_IDENTIFIER_LABEL = exports.USERNAME_REQUIRED = exports.USERNAME_LABEL = exports.URGENCY_LABEL = exports.UPDATE_SUCCESS_TOAST_TITLE = exports.UPDATE_SUCCESS_TOAST_TEXT = exports.UNKNOWN = exports.TYPE = exports.TITLE_REQUIRED = exports.SUBCATEGORY_LABEL = exports.SOURCE = exports.SN_INSTANCE_LABEL = exports.SHORT_DESCRIPTION_LABEL = exports.SEVERITY_REQUIRED = exports.SEVERITY_LABEL = exports.SETUP_DEV_INSTANCE = exports.SECURITY_INCIDENT = exports.RESOURCE = exports.REQUIRED_LABEL = exports.PRIVATE_KEY_REQUIRED = exports.PRIVATE_KEY_PASSWORD_LABEL = exports.PRIVATE_KEY_PASSWORD_HELPER_TEXT = exports.PRIVATE_KEY_LABEL = exports.PRIORITY_LABEL = exports.PASSWORD_REQUIRED = exports.PASSWORD_LABEL = exports.OPTIONAL_LABEL = exports.NODE = exports.METRIC_NAME = exports.MESSAGE_KEY = exports.KEY_ID_LABEL = exports.KEYID_REQUIRED = exports.IS_OAUTH = exports.INSTALLATION_CALLOUT_TITLE = exports.INCIDENT = exports.IMPACT_LABEL = exports.FETCH_ERROR = exports.EVENT_CLASS = exports.EVENT_ACTION_TRIGGER = exports.EVENT_ACTION_RESOLVE = exports.EVENT_ACTION_LABEL = exports.EVENT = exports.DESCRIPTION_LABEL = exports.CORRELATION_ID_REQUIRED = exports.CORRELATION_ID = exports.CORRELATION_DISPLAY = exports.COMMENTS_LABEL = exports.CLIENTSECRET_REQUIRED = exports.CLIENTSECRET_LABEL = exports.CLIENTID_REQUIRED = exports.CLIENTID_LABEL = exports.CHOICES_API_ERROR = exports.CATEGORY_LABEL = exports.AUTHENTICATION_LABEL = exports.API_URL_LABEL = exports.API_URL_INVALID = exports.API_INFO_ERROR = exports.ADDITIONAL_INFO_JSON_ERROR = exports.ADDITIONAL_INFO_HELP = exports.ADDITIONAL_INFO = exports.ADDITIONAL_FIELDS_HELP_SERVICENOW_TEXT = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const API_URL_LABEL = exports.API_URL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.apiUrlTextFieldLabel', {
  defaultMessage: 'ServiceNow instance URL'
});
const API_URL_INVALID = exports.API_URL_INVALID = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.invalidApiUrlTextField', {
  defaultMessage: 'URL is invalid.'
});
const AUTHENTICATION_LABEL = exports.AUTHENTICATION_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.authenticationLabel', {
  defaultMessage: 'Authentication'
});
const USERNAME_LABEL = exports.USERNAME_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.usernameTextFieldLabel', {
  defaultMessage: 'Username'
});
const USERNAME_REQUIRED = exports.USERNAME_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.requiredUsernameTextField', {
  defaultMessage: 'Username is required.'
});
const PASSWORD_LABEL = exports.PASSWORD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.passwordTextFieldLabel', {
  defaultMessage: 'Password'
});
const TITLE_REQUIRED = exports.TITLE_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.requiredShortDescTextField', {
  defaultMessage: 'Short description is required.'
});
const CORRELATION_ID_REQUIRED = exports.CORRELATION_ID_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.requiredCorrelationIdTextField', {
  defaultMessage: 'Correlation id is required.'
});
const INCIDENT = exports.INCIDENT = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.title', {
  defaultMessage: 'Incident'
});
const SECURITY_INCIDENT = exports.SECURITY_INCIDENT = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNowSIR.title', {
  defaultMessage: 'Security incident'
});
const SHORT_DESCRIPTION_LABEL = exports.SHORT_DESCRIPTION_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.titleFieldLabel', {
  defaultMessage: 'Short description'
});
const DESCRIPTION_LABEL = exports.DESCRIPTION_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.descriptionTextAreaFieldLabel', {
  defaultMessage: 'Description'
});
const COMMENTS_LABEL = exports.COMMENTS_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.commentsTextAreaFieldLabel', {
  defaultMessage: 'Additional comments'
});
const CHOICES_API_ERROR = exports.CHOICES_API_ERROR = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.unableToGetChoicesMessage', {
  defaultMessage: 'Unable to get choices'
});
const CATEGORY_LABEL = exports.CATEGORY_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.categoryTitle', {
  defaultMessage: 'Category'
});
const SUBCATEGORY_LABEL = exports.SUBCATEGORY_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.subcategoryTitle', {
  defaultMessage: 'Subcategory'
});
const URGENCY_LABEL = exports.URGENCY_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.urgencySelectFieldLabel', {
  defaultMessage: 'Urgency'
});
const SEVERITY_LABEL = exports.SEVERITY_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.severitySelectFieldLabel', {
  defaultMessage: 'Severity'
});
const IMPACT_LABEL = exports.IMPACT_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.impactSelectFieldLabel', {
  defaultMessage: 'Impact'
});
const PRIORITY_LABEL = exports.PRIORITY_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.prioritySelectFieldLabel', {
  defaultMessage: 'Priority'
});
const API_INFO_ERROR = status => _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.apiInfoError', {
  values: {
    status
  },
  defaultMessage: 'Received status: {status} when attempting to get application information'
});
exports.API_INFO_ERROR = API_INFO_ERROR;
const FETCH_ERROR = exports.FETCH_ERROR = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.fetchErrorMsg', {
  defaultMessage: 'Failed to fetch. Check the URL or the CORS configuration of your ServiceNow instance.'
});
const INSTALLATION_CALLOUT_TITLE = exports.INSTALLATION_CALLOUT_TITLE = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.installationCalloutTitle', {
  defaultMessage: 'To use this connector, first install the Elastic app from the ServiceNow app store.'
});
const UPDATE_SUCCESS_TOAST_TITLE = connectorName => _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.updateSuccessToastTitle', {
  defaultMessage: '{connectorName} connector updated',
  values: {
    connectorName
  }
});
exports.UPDATE_SUCCESS_TOAST_TITLE = UPDATE_SUCCESS_TOAST_TITLE;
const UPDATE_SUCCESS_TOAST_TEXT = exports.UPDATE_SUCCESS_TOAST_TEXT = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.updateCalloutText', {
  defaultMessage: 'Connector has been updated.'
});
const VISIT_SN_STORE = exports.VISIT_SN_STORE = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.visitSNStore', {
  defaultMessage: 'Visit ServiceNow app store'
});
const SETUP_DEV_INSTANCE = exports.SETUP_DEV_INSTANCE = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.setupDevInstance', {
  defaultMessage: 'setup a developer instance'
});
const SN_INSTANCE_LABEL = exports.SN_INSTANCE_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.snInstanceLabel', {
  defaultMessage: 'ServiceNow instance'
});
const UNKNOWN = exports.UNKNOWN = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.unknown', {
  defaultMessage: 'UNKNOWN'
});
const CORRELATION_ID = exports.CORRELATION_ID = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.correlationID', {
  defaultMessage: 'Correlation ID'
});
const CORRELATION_DISPLAY = exports.CORRELATION_DISPLAY = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.correlationDisplay', {
  defaultMessage: 'Correlation display'
});
const EVENT = exports.EVENT = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNowITOM.event', {
  defaultMessage: 'Event'
});

/**
 * ITOM
 */
const SOURCE = exports.SOURCE = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.sourceTextAreaFieldLabel', {
  defaultMessage: 'Source'
});
const EVENT_CLASS = exports.EVENT_CLASS = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.eventClassTextAreaFieldLabel', {
  defaultMessage: 'Source instance'
});
const RESOURCE = exports.RESOURCE = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.resourceTextAreaFieldLabel', {
  defaultMessage: 'Resource'
});
const NODE = exports.NODE = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.nodeTextAreaFieldLabel', {
  defaultMessage: 'Node'
});
const METRIC_NAME = exports.METRIC_NAME = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.metricNameTextAreaFieldLabel', {
  defaultMessage: 'Metric name'
});
const TYPE = exports.TYPE = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.typeTextAreaFieldLabel', {
  defaultMessage: 'Type'
});
const MESSAGE_KEY = exports.MESSAGE_KEY = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.messageKeyTextAreaFieldLabel', {
  defaultMessage: 'Message key'
});
const SEVERITY_REQUIRED = exports.SEVERITY_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.requiredSeverityTextField', {
  defaultMessage: 'Severity is required.'
});
const CLIENTID_LABEL = exports.CLIENTID_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.clientIdTextFieldLabel', {
  defaultMessage: 'Client ID'
});
const CLIENTSECRET_LABEL = exports.CLIENTSECRET_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.clientSecretTextFieldLabel', {
  defaultMessage: 'Client secret'
});
const KEY_ID_LABEL = exports.KEY_ID_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.keyIdTextFieldLabel', {
  defaultMessage: 'JWT verifier key ID'
});
const USER_IDENTIFIER_LABEL = exports.USER_IDENTIFIER_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.userEmailTextFieldLabel', {
  defaultMessage: 'User identifier'
});
const PRIVATE_KEY_LABEL = exports.PRIVATE_KEY_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.privateKeyTextFieldLabel', {
  defaultMessage: 'Private key'
});
const PRIVATE_KEY_PASSWORD_LABEL = exports.PRIVATE_KEY_PASSWORD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.privateKeyPassTextFieldLabel', {
  defaultMessage: 'Private key password'
});
const PRIVATE_KEY_PASSWORD_HELPER_TEXT = exports.PRIVATE_KEY_PASSWORD_HELPER_TEXT = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.privateKeyPassLabelHelpText', {
  defaultMessage: 'This is only required if you have set a password on your private key'
});
const CLIENTID_REQUIRED = exports.CLIENTID_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.requiredClientIdTextField', {
  defaultMessage: 'Client ID is required.'
});
const PRIVATE_KEY_REQUIRED = exports.PRIVATE_KEY_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.requiredPrivateKeyTextField', {
  defaultMessage: 'Private key is required.'
});
const KEYID_REQUIRED = exports.KEYID_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.requiredKeyIdTextField', {
  defaultMessage: 'JWT verifier key ID is required.'
});
const USER_IDENTIFIER_REQUIRED = exports.USER_IDENTIFIER_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.requiredUserIdentifierTextField', {
  defaultMessage: 'User identifier is required.'
});
const PASSWORD_REQUIRED = exports.PASSWORD_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.requiredPasswordTextField', {
  defaultMessage: 'Password is required.'
});
const CLIENTSECRET_REQUIRED = exports.CLIENTSECRET_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.requiredClientSecretTextField', {
  defaultMessage: 'Client secret is required.'
});
const IS_OAUTH = exports.IS_OAUTH = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.useOAuth', {
  defaultMessage: 'Use OAuth authentication'
});
const OPTIONAL_LABEL = exports.OPTIONAL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.optionalLabel', {
  defaultMessage: 'Optional'
});
const REQUIRED_LABEL = exports.REQUIRED_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.requiredLabel', {
  defaultMessage: 'Required'
});
const EVENT_ACTION_TRIGGER = exports.EVENT_ACTION_TRIGGER = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.eventActionTriggerOptionLabel', {
  defaultMessage: 'Trigger'
});
const EVENT_ACTION_RESOLVE = exports.EVENT_ACTION_RESOLVE = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.eventActionResolveOptionLabel', {
  defaultMessage: 'Resolve'
});
const EVENT_ACTION_LABEL = exports.EVENT_ACTION_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNowITSM.eventActionFieldLabel', {
  defaultMessage: 'Event action'
});
const ADDITIONAL_FIELDS_HELP_SERVICENOW_TEXT = exports.ADDITIONAL_FIELDS_HELP_SERVICENOW_TEXT = _i18n.i18n.translate('xpack.stackConnectors.components.servicenow.additionalFieldsHelpTooltipText', {
  defaultMessage: 'Additional fields in JSON format as defined in the Elastic ServiceNow application'
});
const ADDITIONAL_INFO = exports.ADDITIONAL_INFO = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNowITOM.additionalInfoLabel', {
  defaultMessage: 'Additional info'
});
const ADDITIONAL_INFO_HELP = exports.ADDITIONAL_INFO_HELP = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNowITOM.additionalInfoHelpTooltip', {
  defaultMessage: 'Additional info help'
});
const ADDITIONAL_INFO_JSON_ERROR = exports.ADDITIONAL_INFO_JSON_ERROR = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNowITOM.additionalInfoError', {
  defaultMessage: 'The additional info field does not have a valid JSON format.'
});