"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Tags = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _constants = require("../../../../common/jira-service-management/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _optional_field_label = require("../../../common/optional_field_label");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/jira-service-management/create_alert/tags.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const options = [{
  label: _constants.RULE_TAGS_TEMPLATE,
  key: _constants.RULE_TAGS_TEMPLATE,
  'data-test-subj': 'jsm-tags-rule-tags',
  value: i18n.RULE_TAGS_DESCRIPTION
}];
const TagsComponent = ({
  onChange,
  values,
  executionMode
}) => {
  const tagOptions = (0, _react.useMemo)(() => values.map(value => getTagAsOption(value)), [values]);
  const onCreateOption = (0, _react.useCallback)(tagValue => {
    const newTags = [...tagOptions, getTagAsOption(tagValue)];
    onChange('tags', newTags.map(tag => tag.label));
  }, [onChange, tagOptions]);
  const onTagsChange = (0, _react.useCallback)(newOptions => {
    onChange('tags', newOptions.map(option => option.label));
  }, [onChange]);
  const renderOption = (0, _react.useCallback)((option, searchValue) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "baseline",
      gutterSize: "none",
      direction: "column",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
      search: searchValue,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 11
      }
    }, option.label)), option.value && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 13
      }
    }, option.value)));
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "jsm-tags-row",
    fullWidth: true,
    label: i18n.TAGS_FIELD_LABEL,
    labelAppend: _optional_field_label.OptionalFieldLabel,
    helpText: i18n.TAGS_HELP,
    "aria-label": i18n.TAGS_FIELD_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    rowHeight: 50,
    fullWidth: true,
    isClearable: true,
    options: executionMode === _public.ActionConnectorMode.ActionForm ? options : undefined,
    selectedOptions: tagOptions,
    onCreateOption: onCreateOption,
    onChange: onTagsChange,
    "data-test-subj": "jsm-tags",
    renderOption: renderOption,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }));
};
TagsComponent.displayName = 'Tags';
const Tags = exports.Tags = /*#__PURE__*/_react.default.memo(TagsComponent);
const getTagAsOption = value => ({
  label: value,
  key: value
});