"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateAlert = void 0;
Object.defineProperty(exports, "isPartialCreateAlertSchema", {
  enumerable: true,
  get: function () {
    return _schema.isPartialCreateAlertSchema;
  }
});
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _display_more_options = require("../display_more_options");
var _additional_options = require("./additional_options");
var _tags = require("./tags");
var _priority = require("./priority");
var _optional_field_label = require("../../../common/optional_field_label");
var _schema = require("./schema");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/jira-service-management/create_alert/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const JsonEditorLazy = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./json_editor'))));
const FormView = ({
  editSubAction,
  editOptionalSubAction,
  errors,
  index,
  messageVariables,
  subActionParams,
  showSaveError,
  executionMode
}) => {
  var _subActionParams$tags;
  const isMessageInvalid = errors['subActionParams.message'] !== undefined && Number(errors['subActionParams.message'].length) > 0 && (subActionParams === null || subActionParams === void 0 ? void 0 : subActionParams.message) !== undefined || showSaveError;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "jsm-message-row",
    fullWidth: true,
    error: errors['subActionParams.message'],
    label: i18n.MESSAGE_FIELD_LABEL,
    isInvalid: isMessageInvalid,
    "aria-label": i18n.MESSAGE_FIELD_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: editSubAction,
    messageVariables: messageVariables,
    paramsProperty: 'message',
    inputTargetValue: subActionParams === null || subActionParams === void 0 ? void 0 : subActionParams.message,
    errors: errors['subActionParams.message'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_tags.Tags, {
    values: (_subActionParams$tags = subActionParams === null || subActionParams === void 0 ? void 0 : subActionParams.tags) !== null && _subActionParams$tags !== void 0 ? _subActionParams$tags : [],
    onChange: editOptionalSubAction,
    executionMode: executionMode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_priority.Priority, {
    priority: subActionParams === null || subActionParams === void 0 ? void 0 : subActionParams.priority,
    onChange: editOptionalSubAction,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_public.TextAreaWithMessageVariables, {
    index: index,
    editAction: editOptionalSubAction,
    messageVariables: messageVariables,
    paramsProperty: 'description',
    label: i18n.DESCRIPTION_FIELD_LABEL,
    inputTargetValue: subActionParams === null || subActionParams === void 0 ? void 0 : subActionParams.description,
    isOptionalField: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "jsm-alias-row",
    fullWidth: true,
    label: i18n.ALIAS_FIELD_LABEL,
    helpText: i18n.JIRA_SERVICE_MANAGEMENT_ALIAS_HELP,
    labelAppend: _optional_field_label.OptionalFieldLabel,
    "aria-label": i18n.ALIAS_FIELD_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: editOptionalSubAction,
    messageVariables: messageVariables,
    paramsProperty: 'alias',
    inputTargetValue: subActionParams === null || subActionParams === void 0 ? void 0 : subActionParams.alias,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  })));
};
FormView.displayName = 'FormView';
const CreateAlertComponent = ({
  editSubAction,
  editAction,
  editOptionalSubAction,
  errors,
  index,
  messageVariables,
  subActionParams,
  showSaveError,
  executionMode
}) => {
  const [showingMoreOptions, setShowingMoreOptions] = (0, _react.useState)(false);
  const [showJsonEditor, setShowJsonEditor] = (0, _react.useState)(false);
  const toggleShowJsonEditor = (0, _react.useCallback)(event => {
    if (!event.target.checked) {
      // when the user switches back remove the json editor error if there was one
      // must mark as undefined to remove the field so it is not sent to the server side
      editAction('jsonEditorError', undefined, index);
    }
    setShowJsonEditor(event.target.checked);
  }, [editAction, index]);
  const toggleShowingMoreOptions = (0, _react.useCallback)(() => setShowingMoreOptions(previousState => !previousState), []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: i18n.USE_JSON_EDITOR_LABEL,
    checked: showJsonEditor,
    onChange: toggleShowJsonEditor,
    "data-test-subj": "jsm-show-json-editor-toggle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 7
    }
  }), showJsonEditor ? /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_public.SectionLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 31
      }
    }, i18n.LOADING_JSON_EDITOR),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(JsonEditorLazy, {
    editAction: editAction,
    index: index,
    messageVariables: messageVariables,
    subActionParams: subActionParams,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 13
    }
  }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(FormView, {
    editOptionalSubAction: editOptionalSubAction,
    editSubAction: editSubAction,
    errors: errors,
    index: index,
    messageVariables: messageVariables,
    subActionParams: subActionParams,
    showSaveError: showSaveError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_display_more_options.DisplayMoreOptions, {
    showingMoreOptions: showingMoreOptions,
    toggleShowingMoreOptions: toggleShowingMoreOptions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 11
    }
  }), showingMoreOptions ? /*#__PURE__*/_react.default.createElement(_additional_options.AdditionalOptions, {
    subActionParams: subActionParams,
    editOptionalSubAction: editOptionalSubAction,
    messageVariables: messageVariables,
    index: index,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 13
    }
  }) : null));
};
CreateAlertComponent.displayName = 'CreateAlert';
const CreateAlert = exports.CreateAlert = /*#__PURE__*/_react.default.memo(CreateAlertComponent);