"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.statuses = exports.caseStatuses = exports.StatusFilter = void 0;
var _react = _interopRequireDefault(require("react"));
var _casesComponents = require("@kbn/cases-components");
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/cases_webhook/status_filter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const caseStatuses = exports.caseStatuses = [_casesComponents.CaseStatuses.open, _casesComponents.CaseStatuses['in-progress'], _casesComponents.CaseStatuses.closed];
const statuses = exports.statuses = {
  [_casesComponents.CaseStatuses.open]: {
    color: 'primary',
    label: i18n.STATUS_OPEN
  },
  [_casesComponents.CaseStatuses['in-progress']]: {
    color: 'warning',
    label: i18n.STATUS_IN_PROGRESS
  },
  [_casesComponents.CaseStatuses.closed]: {
    color: 'default',
    label: i18n.STATUS_CLOSED
  }
};
const StatusFilter = ({
  selectedStatus,
  onStatusChanged
}) => {
  const options = caseStatuses.map(status => {
    var _statuses$status, _statuses$status2;
    return {
      value: status,
      inputDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        alignItems: 'center',
        responsive: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 41,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 42,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 43,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        "data-test-subj": `case-status-badge-${status}`,
        color: (_statuses$status = statuses[status]) === null || _statuses$status === void 0 ? void 0 : _statuses$status.color,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 44,
          columnNumber: 13
        }
      }, (_statuses$status2 = statuses[status]) === null || _statuses$status2 === void 0 ? void 0 : _statuses$status2.label)))),
      'data-test-subj': `case-status-filter-${status}`
    };
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    options: options,
    valueOfSelected: selectedStatus,
    onChange: onStatusChanged,
    "data-test-subj": "case-status-filter",
    fullWidth: true,
    "aria-label": i18n.CASE_STATUS_ARIA_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  });
};
exports.StatusFilter = StatusFilter;
StatusFilter.displayName = 'StatusFilter';