"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.errorResult = errorResult;
exports.retryResult = retryResult;
exports.retryResultSeconds = retryResultSeconds;
exports.serviceErrorResult = serviceErrorResult;
exports.successResult = successResult;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function successResult(actionId, data) {
  return {
    status: 'ok',
    data,
    actionId
  };
}
function errorResult(actionId, message, errorSource) {
  return {
    status: 'error',
    message,
    actionId,
    errorSource
  };
}
function serviceErrorResult(actionId, serviceMessage) {
  const errMessage = _i18n.i18n.translate('xpack.stackConnectors.slack.errorPostingErrorMessage', {
    defaultMessage: 'error posting slack message'
  });
  return {
    status: 'error',
    message: errMessage,
    actionId,
    serviceMessage
  };
}
function retryResult(actionId, message) {
  const errMessage = _i18n.i18n.translate('xpack.stackConnectors.slack.errorPostingRetryLaterErrorMessage', {
    defaultMessage: 'error posting a slack message, retry later'
  });
  return {
    status: 'error',
    message: errMessage,
    retry: true,
    actionId
  };
}
function retryResultSeconds(actionId, message, retryAfter) {
  const retryEpoch = Date.now() + retryAfter * 1000;
  const retry = new Date(retryEpoch);
  const retryString = retry.toISOString();
  const errMessage = _i18n.i18n.translate('xpack.stackConnectors.slack.errorPostingRetryDateErrorMessage', {
    defaultMessage: 'error posting a slack message, retry at {retryString}',
    values: {
      retryString
    }
  });
  return {
    status: 'error',
    message: errMessage,
    retry,
    actionId,
    serviceMessage: message
  };
}