"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnifiedChatCompleteResponseSchema = exports.UnifiedChatCompleteParamsSchema = exports.TextEmbeddingResponseSchema = exports.TextEmbeddingParamsSchema = exports.TelemtryMetadataSchema = exports.StreamingResponseSchema = exports.SparseEmbeddingResponseSchema = exports.SparseEmbeddingParamsSchema = exports.SecretsSchema = exports.RerankResponseSchema = exports.RerankParamsSchema = exports.DashboardActionResponseSchema = exports.DashboardActionParamsSchema = exports.ConfigSchema = exports.ChatCompleteResponseSchema = exports.ChatCompleteParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TelemtryMetadataSchema = exports.TelemtryMetadataSchema = _configSchema.schema.object({
  pluginId: _configSchema.schema.maybe(_configSchema.schema.string()),
  aggregateBy: _configSchema.schema.maybe(_configSchema.schema.string())
});
const ConfigSchema = exports.ConfigSchema = _configSchema.schema.object({
  provider: _configSchema.schema.string(),
  taskType: _configSchema.schema.string(),
  inferenceId: _configSchema.schema.string(),
  providerConfig: _configSchema.schema.object({}, {
    unknowns: 'allow',
    defaultValue: {}
  }),
  taskTypeConfig: _configSchema.schema.object({}, {
    unknowns: 'allow',
    defaultValue: {}
  }),
  contextWindowLength: _configSchema.schema.maybe(_configSchema.schema.number({}))
});
const SecretsSchema = exports.SecretsSchema = _configSchema.schema.object({
  providerSecrets: _configSchema.schema.object({}, {
    unknowns: 'allow',
    defaultValue: {}
  })
});
const ChatCompleteParamsSchema = exports.ChatCompleteParamsSchema = _configSchema.schema.object({
  input: _configSchema.schema.string()
});

// subset of OpenAI.ChatCompletionMessageParam https://github.com/openai/openai-node/blob/master/src/resources/chat/completions.ts
const AIMessage = _configSchema.schema.object({
  role: _configSchema.schema.string(),
  content: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string())),
  name: _configSchema.schema.maybe(_configSchema.schema.string()),
  tool_calls: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
    id: _configSchema.schema.string(),
    function: _configSchema.schema.object({
      arguments: _configSchema.schema.maybe(_configSchema.schema.string()),
      name: _configSchema.schema.maybe(_configSchema.schema.string())
    }),
    type: _configSchema.schema.string()
  }))),
  tool_call_id: _configSchema.schema.maybe(_configSchema.schema.string())
});
const AITool = _configSchema.schema.object({
  type: _configSchema.schema.string(),
  function: _configSchema.schema.object({
    name: _configSchema.schema.string(),
    description: _configSchema.schema.maybe(_configSchema.schema.string()),
    parameters: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any()))
  })
});

// subset of OpenAI.ChatCompletionCreateParamsBase https://github.com/openai/openai-node/blob/master/src/resources/chat/completions.ts
const UnifiedChatCompleteParamsSchema = exports.UnifiedChatCompleteParamsSchema = _configSchema.schema.object({
  body: _configSchema.schema.object({
    messages: _configSchema.schema.arrayOf(AIMessage, {
      defaultValue: []
    }),
    model: _configSchema.schema.maybe(_configSchema.schema.string()),
    /**
     * The maximum number of [tokens](/tokenizer) that can be generated in the chat
     * completion. This value can be used to control
     * [costs](https://openai.com/api/pricing/) for text generated via API.
     *
     * This value is now deprecated in favor of `max_completion_tokens`, and is not
     * compatible with
     * [o1 series models](https://platform.openai.com/docs/guides/reasoning).
     */
    max_tokens: _configSchema.schema.maybe(_configSchema.schema.number()),
    /**
     * Developer-defined tags and values used for filtering completions in the
     * [dashboard](https://platform.openai.com/chat-completions).
     */
    metadata: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.string())),
    /**
     * How many chat completion choices to generate for each input message. Note that
     * you will be charged based on the number of generated tokens across all of the
     * choices. Keep `n` as `1` to minimize costs.
     */
    n: _configSchema.schema.maybe(_configSchema.schema.number()),
    /**
     * Up to 4 sequences where the API will stop generating further tokens.
     */
    stop: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.arrayOf(_configSchema.schema.string())]))),
    /**
     * What sampling temperature to use, between 0 and 2. Higher values like 0.8 will
     * make the output more random, while lower values like 0.2 will make it more
     * focused and deterministic.
     *
     * We generally recommend altering this or `top_p` but not both.
     */
    temperature: _configSchema.schema.maybe(_configSchema.schema.number()),
    /**
     * Controls which (if any) tool is called by the model. `none` means the model will
     * not call any tool and instead generates a message. `auto` means the model can
     * pick between generating a message or calling one or more tools. `required` means
     * the model must call one or more tools. Specifying a particular tool via
     * `{"type": "function", "function": {"name": "my_function"}}` forces the model to
     * call that tool.
     *
     * `none` is the default when no tools are present. `auto` is the default if tools
     * are present.
     */
    tool_choice: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.object({
      type: _configSchema.schema.string(),
      function: _configSchema.schema.object({
        name: _configSchema.schema.string()
      })
    })])),
    /**
     * A list of tools the model may call. Currently, only functions are supported as a
     * tool. Use this to provide a list of functions the model may generate JSON inputs
     * for. A max of 128 functions are supported.
     */
    tools: _configSchema.schema.maybe(_configSchema.schema.arrayOf(AITool)),
    /**
     * An alternative to sampling with temperature, called nucleus sampling, where the
     * model considers the results of the tokens with top_p probability mass. So 0.1
     * means only the tokens comprising the top 10% probability mass are considered.
     *
     * We generally recommend altering this or `temperature` but not both.
     */
    top_p: _configSchema.schema.maybe(_configSchema.schema.number()),
    /**
     * A unique identifier representing your end-user, which can help OpenAI to monitor
     * and detect abuse.
     * [Learn more](https://platform.openai.com/docs/guides/safety-best-practices/end-user-ids).
     */
    user: _configSchema.schema.maybe(_configSchema.schema.string())
  }),
  // abort signal from client
  signal: _configSchema.schema.maybe(_configSchema.schema.any()),
  telemetryMetadata: _configSchema.schema.maybe(TelemtryMetadataSchema)
});
const UnifiedChatCompleteResponseSchema = exports.UnifiedChatCompleteResponseSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  choices: _configSchema.schema.arrayOf(_configSchema.schema.object({
    finish_reason: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.oneOf([_configSchema.schema.literal('stop'), _configSchema.schema.literal('length'), _configSchema.schema.literal('tool_calls'), _configSchema.schema.literal('content_filter'), _configSchema.schema.literal('function_call')]))),
    index: _configSchema.schema.maybe(_configSchema.schema.number()),
    message: _configSchema.schema.object({
      content: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string())),
      refusal: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string())),
      role: _configSchema.schema.maybe(_configSchema.schema.string()),
      tool_calls: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
        id: _configSchema.schema.maybe(_configSchema.schema.string()),
        index: _configSchema.schema.maybe(_configSchema.schema.number()),
        function: _configSchema.schema.maybe(_configSchema.schema.object({
          arguments: _configSchema.schema.maybe(_configSchema.schema.string()),
          name: _configSchema.schema.maybe(_configSchema.schema.string())
        })),
        type: _configSchema.schema.maybe(_configSchema.schema.string())
      }), {
        defaultValue: []
      }))
    })
  }), {
    defaultValue: []
  }),
  created: _configSchema.schema.maybe(_configSchema.schema.number()),
  model: _configSchema.schema.maybe(_configSchema.schema.string()),
  object: _configSchema.schema.maybe(_configSchema.schema.string()),
  usage: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.object({
    completion_tokens: _configSchema.schema.maybe(_configSchema.schema.number()),
    prompt_tokens: _configSchema.schema.maybe(_configSchema.schema.number()),
    total_tokens: _configSchema.schema.maybe(_configSchema.schema.number())
  })))
});
const ChatCompleteResponseSchema = exports.ChatCompleteResponseSchema = _configSchema.schema.arrayOf(_configSchema.schema.object({
  result: _configSchema.schema.string()
}), {
  defaultValue: []
});
const RerankParamsSchema = exports.RerankParamsSchema = _configSchema.schema.object({
  input: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    defaultValue: []
  }),
  query: _configSchema.schema.string()
});
const RerankResponseSchema = exports.RerankResponseSchema = _configSchema.schema.arrayOf(_configSchema.schema.object({
  text: _configSchema.schema.maybe(_configSchema.schema.string()),
  index: _configSchema.schema.number(),
  score: _configSchema.schema.number()
}), {
  defaultValue: []
});
const SparseEmbeddingParamsSchema = exports.SparseEmbeddingParamsSchema = _configSchema.schema.object({
  input: _configSchema.schema.string()
});
const SparseEmbeddingResponseSchema = exports.SparseEmbeddingResponseSchema = _configSchema.schema.arrayOf(_configSchema.schema.object({}, {
  unknowns: 'allow'
}), {
  defaultValue: []
});
const TextEmbeddingParamsSchema = exports.TextEmbeddingParamsSchema = _configSchema.schema.object({
  input: _configSchema.schema.string(),
  inputType: _configSchema.schema.string()
});
const TextEmbeddingResponseSchema = exports.TextEmbeddingResponseSchema = _configSchema.schema.arrayOf(_configSchema.schema.object({
  embedding: _configSchema.schema.arrayOf(_configSchema.schema.any(), {
    defaultValue: []
  })
}), {
  defaultValue: []
});
const StreamingResponseSchema = exports.StreamingResponseSchema = _configSchema.schema.stream();

// Run action schema
const DashboardActionParamsSchema = exports.DashboardActionParamsSchema = _configSchema.schema.object({
  dashboardId: _configSchema.schema.string()
});
const DashboardActionResponseSchema = exports.DashboardActionResponseSchema = _configSchema.schema.object({
  available: _configSchema.schema.boolean()
});