"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformResults = transformResults;
var _lodash = _interopRequireDefault(require("lodash"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Flatten agg results and get latest locations for each entity
function transformResults(
// eslint-disable-next-line @typescript-eslint/no-explicit-any
results, dateField, geoField) {
  var _results$aggregations, _results$aggregations2, _results$aggregations3;
  const resultsMap = new Map();
  const boundarySplitBuckets = (_results$aggregations = results === null || results === void 0 ? void 0 : (_results$aggregations2 = results.aggregations) === null || _results$aggregations2 === void 0 ? void 0 : (_results$aggregations3 = _results$aggregations2.shapes) === null || _results$aggregations3 === void 0 ? void 0 : _results$aggregations3.buckets) !== null && _results$aggregations !== void 0 ? _results$aggregations : {};
  for (const boundaryId in boundarySplitBuckets) {
    var _boundarySplitBuckets, _boundarySplitBuckets2, _boundarySplitBuckets3;
    if (!Object.hasOwn(boundarySplitBuckets, boundaryId)) {
      continue;
    }
    const entitySplitBuckets = (_boundarySplitBuckets = (_boundarySplitBuckets2 = boundarySplitBuckets[boundaryId]) === null || _boundarySplitBuckets2 === void 0 ? void 0 : (_boundarySplitBuckets3 = _boundarySplitBuckets2.entitySplit) === null || _boundarySplitBuckets3 === void 0 ? void 0 : _boundarySplitBuckets3.buckets) !== null && _boundarySplitBuckets !== void 0 ? _boundarySplitBuckets : [];
    for (let i = 0; i < entitySplitBuckets.length; i++) {
      var _resultsMap$get, _entitySplitBuckets$i, _entitySplitBuckets$i2, _entitySplitBuckets$i3, _entitySplitBuckets$i4, _entitySplitBuckets$i5, _entitySplitBuckets$i6, _entitySplitBuckets$i7, _entitySplitBuckets$i8, _entitySplitBuckets$i9, _entitySplitBuckets$i10, _entitySplitBuckets$i11, _entitySplitBuckets$i12, _entitySplitBuckets$i13, _entitySplitBuckets$i14, _entitySplitBuckets$i15, _entitySplitBuckets$i16, _entitySplitBuckets$i17, _entitySplitBuckets$i18;
      const entityName = entitySplitBuckets[i].key;
      const entityResults = (_resultsMap$get = resultsMap.get(entityName)) !== null && _resultsMap$get !== void 0 ? _resultsMap$get : [];
      entityResults.push({
        // Required for zero down time (ZDT)
        // populate legacy location so non-updated-kibana nodes can handle new alert state
        //
        // Why 0,0 vs parsing WKT and populating actual location?
        // This loop gets processed for each entity location in each containing boundary, ie: its a hot loop
        // There is a mimial amount of time between one kibana node updating and all Kibana nodes being updated
        // vs a huge CPU penetatily for all kibana nodes for the rest of the time
        // Algorithm optimized for the more common use case where all Kibana nodes are running updated version
        location: [0, 0],
        locationWkt: (_entitySplitBuckets$i = (_entitySplitBuckets$i2 = entitySplitBuckets[i].entityHits) === null || _entitySplitBuckets$i2 === void 0 ? void 0 : (_entitySplitBuckets$i3 = _entitySplitBuckets$i2.hits) === null || _entitySplitBuckets$i3 === void 0 ? void 0 : (_entitySplitBuckets$i4 = _entitySplitBuckets$i3.hits) === null || _entitySplitBuckets$i4 === void 0 ? void 0 : (_entitySplitBuckets$i5 = _entitySplitBuckets$i4[0]) === null || _entitySplitBuckets$i5 === void 0 ? void 0 : (_entitySplitBuckets$i6 = _entitySplitBuckets$i5.fields) === null || _entitySplitBuckets$i6 === void 0 ? void 0 : (_entitySplitBuckets$i7 = _entitySplitBuckets$i6[geoField]) === null || _entitySplitBuckets$i7 === void 0 ? void 0 : _entitySplitBuckets$i7[0]) !== null && _entitySplitBuckets$i !== void 0 ? _entitySplitBuckets$i : '',
        shapeLocationId: boundaryId,
        dateInShape: (_entitySplitBuckets$i8 = (_entitySplitBuckets$i9 = entitySplitBuckets[i].entityHits) === null || _entitySplitBuckets$i9 === void 0 ? void 0 : (_entitySplitBuckets$i10 = _entitySplitBuckets$i9.hits) === null || _entitySplitBuckets$i10 === void 0 ? void 0 : (_entitySplitBuckets$i11 = _entitySplitBuckets$i10.hits) === null || _entitySplitBuckets$i11 === void 0 ? void 0 : (_entitySplitBuckets$i12 = _entitySplitBuckets$i11[0]) === null || _entitySplitBuckets$i12 === void 0 ? void 0 : (_entitySplitBuckets$i13 = _entitySplitBuckets$i12.fields) === null || _entitySplitBuckets$i13 === void 0 ? void 0 : (_entitySplitBuckets$i14 = _entitySplitBuckets$i13[dateField]) === null || _entitySplitBuckets$i14 === void 0 ? void 0 : _entitySplitBuckets$i14[0]) !== null && _entitySplitBuckets$i8 !== void 0 ? _entitySplitBuckets$i8 : null,
        docId: (_entitySplitBuckets$i15 = entitySplitBuckets[i].entityHits) === null || _entitySplitBuckets$i15 === void 0 ? void 0 : (_entitySplitBuckets$i16 = _entitySplitBuckets$i15.hits) === null || _entitySplitBuckets$i16 === void 0 ? void 0 : (_entitySplitBuckets$i17 = _entitySplitBuckets$i16.hits) === null || _entitySplitBuckets$i17 === void 0 ? void 0 : (_entitySplitBuckets$i18 = _entitySplitBuckets$i17[0]) === null || _entitySplitBuckets$i18 === void 0 ? void 0 : _entitySplitBuckets$i18._id
      });
      resultsMap.set(entityName, entityResults);
    }
  }

  // TODO remove sort
  // legacy algorithm sorted entity hits oldest to newest for an undocumented reason
  // preserving sort to avoid unknown breaking changes
  resultsMap.forEach((value, key) => {
    if (value.length > 1) {
      // sort oldest to newest
      resultsMap.set(key, _lodash.default.orderBy(value, ['dateInShape'], ['desc', 'asc']));
    }
  });
  return resultsMap;
}