"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleType = getRuleType;
var _i18n = require("@kbn/i18n");
var _server = require("@kbn/core/server");
var _common = require("@kbn/data-plugin/common");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _es_query = require("@kbn/response-ops-rule-params/es_query");
var _ = require("..");
var _rule_type_params = require("./rule_type_params");
var _es_query2 = require("../../../common/es_query");
var _executor = require("./executor");
var _util = require("./util");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getRuleType(core, isServerless) {
  const ruleTypeName = _i18n.i18n.translate('xpack.stackAlerts.esQuery.alertTypeTitle', {
    defaultMessage: 'Elasticsearch query'
  });
  const actionGroupName = _i18n.i18n.translate('xpack.stackAlerts.esQuery.actionGroupThresholdMetTitle', {
    defaultMessage: 'Query matched'
  });
  const actionVariableContextDateLabel = _i18n.i18n.translate('xpack.stackAlerts.esQuery.actionVariableContextDateLabel', {
    defaultMessage: 'The date that the alert met the threshold condition.'
  });
  const actionVariableContextValueLabel = _i18n.i18n.translate('xpack.stackAlerts.esQuery.actionVariableContextValueLabel', {
    defaultMessage: 'The value that met the threshold condition.'
  });
  const actionVariableContextHitsLabel = _i18n.i18n.translate('xpack.stackAlerts.esQuery.actionVariableContextHitsLabel', {
    defaultMessage: 'The documents that met the threshold condition.'
  });
  const actionVariableContextMessageLabel = _i18n.i18n.translate('xpack.stackAlerts.esQuery.actionVariableContextMessageLabel', {
    defaultMessage: 'A message for the alert.'
  });
  const actionVariableContextTitleLabel = _i18n.i18n.translate('xpack.stackAlerts.esQuery.actionVariableContextTitleLabel', {
    defaultMessage: 'A title for the alert.'
  });
  const actionVariableContextIndexLabel = _i18n.i18n.translate('xpack.stackAlerts.esQuery.actionVariableContextIndexLabel', {
    defaultMessage: 'The indices the rule queries.'
  });
  const actionVariableContextQueryLabel = _i18n.i18n.translate('xpack.stackAlerts.esQuery.actionVariableContextQueryLabel', {
    defaultMessage: 'The string representation of the Elasticsearch query.'
  });
  const actionVariableContextSizeLabel = _i18n.i18n.translate('xpack.stackAlerts.esQuery.actionVariableContextSizeLabel', {
    defaultMessage: 'The number of documents to pass to the configured actions when the threshold condition is met.'
  });
  const actionVariableContextThresholdLabel = _i18n.i18n.translate('xpack.stackAlerts.esQuery.actionVariableContextThresholdLabel', {
    defaultMessage: 'An array of rule threshold values. For between and notBetween thresholds, there are two values.'
  });
  const actionVariableContextThresholdComparatorLabel = _i18n.i18n.translate('xpack.stackAlerts.esQuery.actionVariableContextThresholdComparatorLabel', {
    defaultMessage: 'The comparison function for the threshold.'
  });
  const actionVariableContextConditionsLabel = _i18n.i18n.translate('xpack.stackAlerts.esQuery.actionVariableContextConditionsLabel', {
    defaultMessage: 'A string that describes the threshold condition.'
  });
  const actionVariableSearchConfigurationLabel = _i18n.i18n.translate('xpack.stackAlerts.esQuery.actionVariableContextSearchConfigurationLabel', {
    defaultMessage: 'The query definition, which uses KQL or Lucene to fetch the documents from Elasticsearch.'
  });
  const actionVariableEsqlQueryLabel = _i18n.i18n.translate('xpack.stackAlerts.esQuery.actionVariableContextEsqlQueryLabel', {
    defaultMessage: 'ES|QL query field used to fetch data from Elasticsearch.'
  });
  const actionVariableContextLinkLabel = _i18n.i18n.translate('xpack.stackAlerts.esQuery.actionVariableContextLinkLabel', {
    defaultMessage: `Navigate to Discover and show the records that triggered
       the alert when the rule is created in Discover. Otherwise, navigate to the status page for the rule.`
  });
  const actionVariableContextGroupingLabel = _i18n.i18n.translate('xpack.stackAlerts.esQuery.actionVariableContextGroupingLabel', {
    defaultMessage: 'The object containing groups that are reporting data'
  });
  const sourceFields = (0, _util.getSourceFields)();
  return {
    id: _ruleDataUtils.ES_QUERY_ID,
    name: ruleTypeName,
    actionGroups: [{
      id: _es_query2.ActionGroupId,
      name: actionGroupName
    }],
    defaultActionGroupId: _es_query2.ActionGroupId,
    validate: {
      params: {
        validate: object => {
          const validated = _es_query.EsQueryRuleParamsSchema.validate(object);
          if (isServerless) {
            (0, _rule_type_params.validateServerless)(validated);
          }
          return validated;
        }
      }
    },
    schemas: {
      params: {
        type: 'config-schema',
        schema: _es_query.EsQueryRuleParamsSchema
      }
    },
    actionVariables: {
      context: [{
        name: 'message',
        description: actionVariableContextMessageLabel
      }, {
        name: 'title',
        description: actionVariableContextTitleLabel
      }, {
        name: 'date',
        description: actionVariableContextDateLabel
      }, {
        name: 'value',
        description: actionVariableContextValueLabel
      }, {
        name: 'hits',
        description: actionVariableContextHitsLabel
      }, {
        name: 'conditions',
        description: actionVariableContextConditionsLabel
      }, {
        name: 'link',
        description: actionVariableContextLinkLabel,
        usesPublicBaseUrl: true
      }, {
        name: 'grouping',
        description: actionVariableContextGroupingLabel
      }],
      params: [{
        name: 'size',
        description: actionVariableContextSizeLabel
      }, {
        name: 'threshold',
        description: actionVariableContextThresholdLabel
      }, {
        name: 'thresholdComparator',
        description: actionVariableContextThresholdComparatorLabel
      }, {
        name: 'searchConfiguration',
        description: actionVariableSearchConfigurationLabel
      }, {
        name: 'esQuery',
        description: actionVariableContextQueryLabel
      }, {
        name: 'index',
        description: actionVariableContextIndexLabel
      }, {
        name: 'esqlQuery',
        description: actionVariableEsqlQueryLabel
      }]
    },
    useSavedObjectReferences: {
      extractReferences: params => {
        if ((0, _util.isSearchSourceRule)(params.searchType)) {
          const [searchConfiguration, references] = (0, _common.extractReferences)(params.searchConfiguration);
          const newParams = {
            ...params,
            searchConfiguration
          };
          return {
            params: newParams,
            references
          };
        }
        return {
          params: params,
          references: []
        };
      },
      injectReferences: (params, references) => {
        if ((0, _util.isSearchSourceRule)(params.searchType)) {
          return {
            ...params,
            searchConfiguration: (0, _common.injectReferences)(params.searchConfiguration, references)
          };
        }
        return params;
      }
    },
    minimumLicenseRequired: 'basic',
    isExportable: true,
    executor: async options => {
      return await (0, _executor.executor)(core, options, sourceFields);
    },
    category: _server.DEFAULT_APP_CATEGORIES.management.id,
    producer: _ruleDataUtils.STACK_ALERTS_FEATURE_ID,
    solution: 'stack',
    doesSetRecoveryContext: true,
    alerts: _.STACK_ALERTS_AAD_CONFIG
  };
}