"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpaceListInternal = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../common/constants");
var _space_avatar = require("../space_avatar");
var _spaces_context = require("../spaces_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/spaces/public/space_list/space_list_internal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// No need to wrap LazySpaceAvatar in an error boundary, because it is one of the first chunks loaded when opening Kibana.
const LazySpaceAvatar = /*#__PURE__*/(0, _react.lazy)(() => (0, _space_avatar.getSpaceAvatarComponent)().then(component => ({
  default: component
})));
const DEFAULT_DISPLAY_LIMIT = 5;
/**
 * Displays a corresponding list of spaces for a given list of saved object namespaces. It shows up to five spaces (and an indicator for any
 * number of spaces that the user is not authorized to see) by default. If more than five named spaces would be displayed, the extras (along
 * with the unauthorized spaces indicator, if present) are hidden behind a button. If '*' (aka "All spaces") is present, it supersedes all
 * of the above and just displays a single badge without a button.
 */
const SpaceListInternal = ({
  namespaces,
  displayLimit = DEFAULT_DISPLAY_LIMIT,
  behaviorContext,
  listOnClick = () => {},
  cursorStyle
}) => {
  const {
    spacesDataPromise
  } = (0, _spaces_context.useSpaces)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isExpanded, setIsExpanded] = (0, _react.useState)(false);
  const [shareToSpacesData, setShareToSpacesData] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    spacesDataPromise.then(x => {
      setShareToSpacesData(x);
    });
  }, [spacesDataPromise]);
  if (!shareToSpacesData) {
    return null;
  }
  const isSharedToAllSpaces = namespaces.includes(_constants.ALL_SPACES_ID);
  const unauthorizedSpacesCount = namespaces.filter(namespace => namespace === _constants.UNKNOWN_SPACE).length;
  let displayedSpaces;
  let button = null;
  if (isSharedToAllSpaces) {
    displayedSpaces = [{
      id: _constants.ALL_SPACES_ID,
      name: _i18n.i18n.translate('xpack.spaces.spaceList.allSpacesLabel', {
        defaultMessage: `* All spaces`
      }),
      initials: '*',
      color: euiTheme.colors.vis.euiColorVisGrey0
    }];
  } else {
    const authorized = namespaces.filter(namespace => namespace !== _constants.UNKNOWN_SPACE);
    const enabledSpaceTargets = [];
    const disabledSpaceTargets = [];
    authorized.forEach(namespace => {
      const spaceTarget = shareToSpacesData.spacesMap.get(namespace);
      if (spaceTarget === undefined) {
        // in the event that a new space was created after this page has loaded, fall back to displaying the space ID
        enabledSpaceTargets.push({
          id: namespace,
          name: namespace
        });
      } else if (behaviorContext === 'outside-space' || !spaceTarget.isActiveSpace) {
        if (spaceTarget.isFeatureDisabled) {
          disabledSpaceTargets.push(spaceTarget);
        } else {
          enabledSpaceTargets.push(spaceTarget);
        }
      }
    });
    const authorizedSpaceTargets = [...enabledSpaceTargets, ...disabledSpaceTargets];
    displayedSpaces = isExpanded || !displayLimit ? authorizedSpaceTargets : authorizedSpaceTargets.slice(0, displayLimit);
    if (displayLimit && authorizedSpaceTargets.length > displayLimit) {
      button = isExpanded ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        size: "xs",
        onClick: () => setIsExpanded(false),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 110,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.spaces.spaceList.showLessSpacesLink",
        defaultMessage: "show less",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 111,
          columnNumber: 11
        }
      })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        size: "xs",
        onClick: () => setIsExpanded(true),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 117,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.spaces.spaceList.showMoreSpacesLink",
        defaultMessage: "+{count} more",
        values: {
          count: authorizedSpaceTargets.length + unauthorizedSpacesCount - displayedSpaces.length
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 118,
          columnNumber: 11
        }
      }));
    }
  }
  const unauthorizedSpacesCountBadge = !isSharedToAllSpaces && (isExpanded || button === null) && unauthorizedSpacesCount > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.spaceList.unauthorizedSpacesCountLabel",
      defaultMessage: "You don't have permission to view these spaces.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    tabIndex: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 11
    }
  }, "+", unauthorizedSpacesCount))) : null;
  const styleProps = {
    style: cursorStyle ? {
      cursor: cursorStyle
    } : undefined
  };
  return /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 25
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    responsive: false,
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 7
    }
  }, displayedSpaces.map(space => {
    const isDisabled = space.isFeatureDisabled;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: space.id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(LazySpaceAvatar, (0, _extends2.default)({
      space: space,
      isDisabled: isDisabled,
      size: 's',
      onClick: listOnClick,
      onKeyPress: listOnClick
    }, styleProps, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 15
      }
    })));
  }), unauthorizedSpacesCountBadge, button));
};
exports.SpaceListInternal = SpaceListInternal;