"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegesRolesForm = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _securityRoleManagementModel = require("@kbn/security-role-management-model");
var _securityUiComponents = require("@kbn/security-ui-components");
var _constants = require("../../../../../common/constants");
var _provider = require("../../provider");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/spaces/public/management/edit_space/roles/component/space_assign_role_privilege_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const createRolesComboBoxOptions = roles => roles.map(role => ({
  label: role.name,
  value: role
}));
const PrivilegesRolesForm = props => {
  var _roleCustomizationAnc2;
  const {
    space,
    onSaveCompleted,
    closeFlyout,
    features,
    defaultSelected = []
  } = props;
  const {
    logger,
    notifications,
    license,
    invokeClient,
    getUrlForApp
  } = (0, _provider.useEditSpaceServices)();
  const {
    dispatch: storeDispatch
  } = (0, _provider.useEditSpaceStore)();
  const [assigningToRole, setAssigningToRole] = (0, _react.useState)(false);
  const [fetchingDataDeps, setFetchingDataDeps] = (0, _react.useState)(false);
  const [kibanaPrivileges, setKibanaPrivileges] = (0, _react.useState)(null);
  const [spaceUnallocatedRoles, setSpaceUnallocatedRole] = (0, _react.useState)([]);
  const [selectedRoles, setSelectedRoles] = (0, _react.useState)(createRolesComboBoxOptions(defaultSelected));
  const manageRoleLinkId = (0, _eui.useGeneratedHtmlId)();
  const isEditOperation = (0, _react.useRef)(Boolean(defaultSelected.length));
  const userInvokedPageVisibilityChange = (0, _react.useRef)(null);
  const fetchRequiredData = (0, _react.useCallback)(async spaceId => {
    setFetchingDataDeps(true);
    const [systemRoles, _kibanaPrivileges] = await invokeClient(clients => Promise.all([clients.rolesClient.getRoles(), clients.privilegesClient.getAll({
      includeActions: true,
      respectLicenseLevel: false
    })]));

    // exclude roles that are already assigned to this space
    setSpaceUnallocatedRole(systemRoles.filter(role => {
      var _role$metadata;
      return !((_role$metadata = role.metadata) !== null && _role$metadata !== void 0 && _role$metadata._reserved) && (!role.kibana.length || role.kibana.every(rolePrivileges => {
        return !(rolePrivileges.spaces.includes(spaceId) || rolePrivileges.spaces.includes('*'));
      }));
    }));
    setKibanaPrivileges(_kibanaPrivileges);
  }, [invokeClient]);
  (0, _react.useEffect)(() => {
    fetchRequiredData(space.id).finally(() => setFetchingDataDeps(false));
  }, [fetchRequiredData, invokeClient, space.id]);
  (0, _react.useEffect)(() => {
    async function visibilityChangeHandler() {
      // page just transitioned back to visible state from hidden state caused by user interaction
      if (userInvokedPageVisibilityChange.current && !document.hidden) {
        await fetchRequiredData(space.id).finally(() => setFetchingDataDeps(false));
      }
    }
    document.addEventListener('visibilitychange', visibilityChangeHandler);
    return () => {
      document.removeEventListener('visibilitychange', visibilityChangeHandler);
    };
  }, [fetchRequiredData, invokeClient, space.id]);
  const selectedRolesCombinedPrivileges = (0, _react.useMemo)(() => {
    const combinedPrivilege = new Set(selectedRoles.reduce((result, selectedRole) => {
      let match = [];
      for (let i = 0; i < selectedRole.value.kibana.length; i++) {
        const {
          spaces,
          base
        } = selectedRole.value.kibana[i];
        if (spaces.includes(space.id)) {
          match = base.length ? base : [_constants.FEATURE_PRIVILEGES_CUSTOM];
          break;
        }
      }
      return result.concat(match);
    }, []));
    return Array.from(combinedPrivilege);
  }, [selectedRoles, space.id]);
  const [roleSpacePrivilege, setRoleSpacePrivilege] = (0, _react.useState)(!selectedRoles.length || !selectedRolesCombinedPrivileges.length ? _constants.FEATURE_PRIVILEGES_CUSTOM : selectedRolesCombinedPrivileges[0]);
  const [roleCustomizationAnchor, setRoleCustomizationAnchor] = (0, _react.useState)(() => {
    var _selectedRoles$;
    if (!selectedRoles.length) {
      // return a skeleton anchor on init when no roles are selected
      return {
        value: {
          name: 'placeholder',
          elasticsearch: {
            cluster: [],
            run_as: [],
            indices: []
          },
          kibana: [{
            spaces: [space.id],
            base: [roleSpacePrivilege === _constants.FEATURE_PRIVILEGES_CUSTOM ? '' : roleSpacePrivilege],
            feature: {}
          }]
        },
        privilegeIndex: 0
      };
    }

    // support instance where the form is opened with roles already preselected
    const defaultAnchor = (_selectedRoles$ = selectedRoles[0]) === null || _selectedRoles$ === void 0 ? void 0 : _selectedRoles$.value;
    const privilegeIndex = defaultAnchor.kibana.findIndex(({
      spaces
    }) => spaces.includes(space.id));
    return {
      value: defaultAnchor,
      privilegeIndex: (privilegeIndex || -1) >= 0 ? privilegeIndex : 0
    };
  });

  /**
   * @description computes the value anchor role that will be used as the starting point for granular customizations
   * on the selected roles.
   */
  const computeRoleCustomizationAnchor = (0, _react.useCallback)((spaceId, _selectedRoles) => {
    let anchor = null;
    for (let i = 0; i < _selectedRoles.length; i++) {
      let role;
      if (role = _selectedRoles[i].value) {
        for (let j = 0; j < _selectedRoles[i].value.kibana.length; j++) {
          let privilegeIterationIndexValue;
          if (privilegeIterationIndexValue = role.kibana[j]) {
            const {
              spaces,
              base
            } = privilegeIterationIndexValue;
            /*
             * check to see if current role already has a custom privilege, if it does we use that as the starting point for all customizations
             * that will happen to all the other selected roles and exit
             */
            if (spaces.includes(spaceId) && !base.length) {
              anchor = {
                value: structuredClone(role),
                privilegeIndex: j
              };
              break;
            }
          }
        }
      }
      if (anchor) break;

      // provide a fallback anchor if no suitable anchor was discovered, and we have reached the end of selected roles iteration
      if (!anchor && role && i === _selectedRoles.length - 1) {
        var _fallbackRole$kibana, _fallbackRole$kibana$, _fallbackRole$kibana2;
        const fallbackRole = structuredClone(role);
        const spacePrivilegeIndex = fallbackRole.kibana.findIndex(({
          spaces
        }) => spaces.includes(spaceId));
        anchor = {
          value: fallbackRole,
          privilegeIndex: (spacePrivilegeIndex || -1) >= 0 ? spacePrivilegeIndex : ((fallbackRole === null || fallbackRole === void 0 ? void 0 : (_fallbackRole$kibana = fallbackRole.kibana) === null || _fallbackRole$kibana === void 0 ? void 0 : (_fallbackRole$kibana$ = (_fallbackRole$kibana2 = _fallbackRole$kibana).push) === null || _fallbackRole$kibana$ === void 0 ? void 0 : _fallbackRole$kibana$.call(_fallbackRole$kibana2, {
            spaces: [spaceId],
            base: [],
            feature: {}
          })) || 0) - 1
        };
      }
    }
    return anchor;
  }, []);
  const onRoleSpacePrivilegeChange = (0, _react.useCallback)(spacePrivilege => {
    if (spacePrivilege === _constants.FEATURE_PRIVILEGES_CUSTOM) {
      const _roleCustomizationAnchor = computeRoleCustomizationAnchor(space.id, selectedRoles);
      if (_roleCustomizationAnchor) setRoleCustomizationAnchor(_roleCustomizationAnchor);
    } else {
      // opt for simple updates for customization anchor when privilege is not a custom one, especially that it's used only for visual treatment
      setRoleCustomizationAnchor(({
        value,
        privilegeIndex
      }) => {
        value.kibana[privilegeIndex] = {
          spaces: [space.id],
          base: [spacePrivilege],
          feature: {}
        };
        return {
          value,
          privilegeIndex
        };
      });
    }

    // persist selected privilege for UI
    setRoleSpacePrivilege(spacePrivilege);
  }, [computeRoleCustomizationAnchor, selectedRoles, space.id]);
  const assignRolesToSpace = (0, _react.useCallback)(async () => {
    try {
      var _roleCustomizationAnc;
      setAssigningToRole(true);
      const newPrivileges = {
        base: roleSpacePrivilege === _constants.FEATURE_PRIVILEGES_CUSTOM ? [] : [roleSpacePrivilege],
        feature: roleSpacePrivilege === _constants.FEATURE_PRIVILEGES_CUSTOM ? (_roleCustomizationAnc = roleCustomizationAnchor.value) === null || _roleCustomizationAnc === void 0 ? void 0 : _roleCustomizationAnc.kibana[roleCustomizationAnchor.privilegeIndex].feature : {}
      };
      const updatedRoles = structuredClone(selectedRoles).map(selectedRole => {
        let found = false;
        for (let i = 0; i < selectedRole.value.kibana.length; i++) {
          const {
            spaces
          } = selectedRole.value.kibana[i];
          if (spaces.includes(space.id)) {
            if (spaces.length > 1) {
              // account for instance where current space belongs to a collection of other spaces that share the same privileges that are grouped together,
              // since we intend to apply the new privilege exclusively to the current space
              // we remove the space from the shared privilege.
              spaces.splice(i, 1);
            } else {
              Object.assign(selectedRole.value.kibana[i], newPrivileges);
              found = true;
            }
            break;
          }
        }
        if (!found) {
          var _selectedRole$value;
          (_selectedRole$value = selectedRole.value) === null || _selectedRole$value === void 0 ? void 0 : _selectedRole$value.kibana.push(Object.assign({
            spaces: [space.id]
          }, newPrivileges));
        }
        return selectedRole.value;
      });
      await invokeClient(clients => clients.rolesClient.bulkUpdateRoles({
        rolesUpdate: updatedRoles
      }).then(response => {
        setAssigningToRole(false);
        onSaveCompleted(response);
      }));
      storeDispatch({
        type: 'update_roles',
        payload: updatedRoles
      });
    } catch (error) {
      var _error$body$message, _error$body;
      logger.error('Could not assign role to space!', error);
      const message = (_error$body$message = error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : error.toString();
      notifications.toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.spaces.management.spaceDetails.errorAssigningRoleTitle', {
          defaultMessage: 'Error assigning role to space: {message}',
          values: {
            message
          }
        })
      });
    }
  }, [roleSpacePrivilege, (_roleCustomizationAnc2 = roleCustomizationAnchor.value) === null || _roleCustomizationAnc2 === void 0 ? void 0 : _roleCustomizationAnc2.kibana, roleCustomizationAnchor.privilegeIndex, selectedRoles, invokeClient, storeDispatch, space.id, onSaveCompleted, logger, notifications.toasts]);
  const getForm = () => {
    var _license$getFeatures$;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
      component: "form",
      fullWidth: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 364,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 365,
        columnNumber: 9
      }
    }, !isEditOperation.current && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      onClick: event => {
        // leverage event propagation, check if manage role link element was clicked
        if (event.target.id === manageRoleLinkId) {
          userInvokedPageVisibilityChange.current = true;
        }
      },
      label: _i18n.i18n.translate('xpack.spaces.management.spaceDetails.roles.selectRolesFormRowLabel', {
        defaultMessage: 'Select roles'
      }),
      labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 379,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        id: manageRoleLinkId,
        href: getUrlForApp('management', {
          deepLinkId: 'roles'
        }),
        external: false,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 380,
          columnNumber: 19
        }
      }, _i18n.i18n.translate('xpack.spaces.management.spaceDetails.roles.selectRolesFormRowLabelAnchor', {
        defaultMessage: 'Manage roles'
      }))),
      helpText: _i18n.i18n.translate('xpack.spaces.management.spaceDetails.roles.selectRolesHelp', {
        defaultMessage: 'Users assigned to selected roles will gain access to this space.'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 367,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      "data-test-subj": "space-assign-role-selection-combo-box",
      "aria-label": _i18n.i18n.translate('xpack.spaces.management.spaceDetails.roles.selectRoles', {
        defaultMessage: 'Select role to assign to the "{spaceName}" space',
        values: {
          spaceName: space.name
        }
      }),
      placeholder: _i18n.i18n.translate('xpack.spaces.management.spaceDetails.roles.selectRolesPlaceholder', {
        defaultMessage: 'Add roles...'
      }),
      isLoading: fetchingDataDeps,
      options: createRolesComboBoxOptions(spaceUnallocatedRoles),
      selectedOptions: selectedRoles,
      onChange: value => setSelectedRoles(value),
      fullWidth: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 401,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 423,
        columnNumber: 9
      }
    }, Boolean(selectedRoles.length) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 425,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 426,
        columnNumber: 15
      }
    }, selectedRolesCombinedPrivileges.length > 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      size: "s",
      color: "warning",
      iconType: "info",
      "data-test-subj": "privilege-conflict-callout",
      title: _i18n.i18n.translate('xpack.spaces.management.spaceDetails.roles.assign.privilegeConflictMsg.title', {
        defaultMessage: 'Selected roles have different privileges granted'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 428,
        columnNumber: 19
      }
    }, _i18n.i18n.translate('xpack.spaces.management.spaceDetails.roles.assign.privilegeConflictMsg.description', {
      defaultMessage: 'Updating the settings here in a bulk will override current individual settings.'
    })) : /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      size: "s",
      color: "primary",
      iconType: "info",
      "data-test-subj": "privilege-info-callout",
      title: _i18n.i18n.translate('xpack.spaces.management.spaceDetails.roles.assign.privilegeCombinationMsg.title', {
        defaultMessage: `The user's resulting access depends on a combination of their role's global space privileges and specific privileges applied to this space.`
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 449,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.spaces.management.spaceDetails.roles.assign.privilegesLabelText', {
        defaultMessage: 'Define privileges'
      }),
      helpText: _i18n.i18n.translate('xpack.spaces.management.spaceDetails.roles.assign.privilegesHelpText', {
        defaultMessage: 'Assign the privilege level you wish to grant to all present and future features across this space.'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 463,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
      "data-test-subj": "space-assign-role-privilege-selection-switch",
      legend: _i18n.i18n.translate('xpack.spaces.management.spaceDetails.roles.assign.privilegeSelectionLegendText', {
        defaultMessage: 'select the privilege for the features enabled in this space'
      }),
      isDisabled: !Boolean(selectedRoles.length),
      options: [{
        id: _constants.FEATURE_PRIVILEGES_ALL,
        label: _i18n.i18n.translate('xpack.spaces.management.spaceDetails.roles.assign.privileges.all', {
          defaultMessage: 'All'
        })
      }, {
        id: _constants.FEATURE_PRIVILEGES_READ,
        label: _i18n.i18n.translate('xpack.spaces.management.spaceDetails.roles.assign.privileges.read', {
          defaultMessage: 'Read'
        })
      }, {
        id: _constants.FEATURE_PRIVILEGES_CUSTOM,
        label: _i18n.i18n.translate('xpack.spaces.management.spaceDetails.roles.assign.privileges.custom', {
          defaultMessage: 'Customize'
        })
      }].map(privilege => ({
        ...privilege,
        'data-test-subj': `${privilege.id}-privilege-button`
      })),
      color: "primary",
      idSelected: roleSpacePrivilege,
      onChange: id => onRoleSpacePrivilegeChange(id),
      isFullWidth: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 478,
        columnNumber: 17
      }
    })), Boolean(selectedRoles.length) && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      "data-test-subj": "space-assign-role-privilege-customization-form",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 522,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 523,
        columnNumber: 19
      }
    }, !kibanaPrivileges ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 525,
        columnNumber: 23
      }
    }) : /*#__PURE__*/_react.default.createElement(_securityUiComponents.KibanaPrivilegeTable, {
      disabled: roleSpacePrivilege !== _constants.FEATURE_PRIVILEGES_CUSTOM,
      role: roleCustomizationAnchor.value,
      privilegeIndex: roleCustomizationAnchor.privilegeIndex,
      onChange: (featureId, selectedPrivileges) => {
        // apply selected changes only to the designated customization anchor, this way we delay reconciling the intending privileges
        // to all of the selected roles till we decide to commit the changes chosen
        setRoleCustomizationAnchor(({
          value,
          privilegeIndex
        }) => {
          var _kibana;
          let privilege;
          if (privilege = (_kibana = value.kibana) === null || _kibana === void 0 ? void 0 : _kibana[privilegeIndex]) {
            privilege.feature[featureId] = selectedPrivileges;
          }
          return {
            value,
            privilegeIndex
          };
        });
      },
      onChangeAll: _privilege => {
        // apply selected changes only to the designated customization anchor, this way we delay reconciling the intending privileges
        // to all of the selected roles till we decide to commit the changes chosen
        setRoleCustomizationAnchor(({
          value,
          privilegeIndex
        }) => {
          var _kibana2;
          let privilege;
          if (privilege = (_kibana2 = value.kibana) === null || _kibana2 === void 0 ? void 0 : _kibana2[privilegeIndex]) {
            // empty out base to setup customizing all features
            privilege.base = [];
            const securedFeatures = new _securityRoleManagementModel.KibanaPrivileges(kibanaPrivileges, features).getSecuredFeatures();
            securedFeatures.forEach(feature => {
              const nextFeaturePrivilege = feature.getPrimaryFeaturePrivileges({
                includeMinimalFeaturePrivileges: true
              }).find(pfp => {
                if (pfp !== null && pfp !== void 0 && pfp.disabled || pfp !== null && pfp !== void 0 && pfp.requireAllSpaces) {
                  return false;
                }
                return Array.isArray(_privilege) && _privilege.includes(pfp.id);
              });
              let newPrivileges = [];
              if (nextFeaturePrivilege) {
                newPrivileges = [nextFeaturePrivilege.id];
                feature.getSubFeaturePrivileges().forEach(psf => {
                  if (Array.isArray(_privilege) && _privilege.includes(psf.id)) {
                    if (!psf.requireAllSpaces) {
                      newPrivileges.push(psf.id);
                    }
                  }
                });
              }
              if (newPrivileges.length === 0) {
                delete privilege.feature[feature.id];
              } else {
                privilege.feature[feature.id] = newPrivileges;
              }
            });
          }
          return {
            value,
            privilegeIndex
          };
        });
      },
      kibanaPrivileges: new _securityRoleManagementModel.KibanaPrivileges(kibanaPrivileges, features),
      privilegeCalculator: new _securityUiComponents.PrivilegeFormCalculator(new _securityRoleManagementModel.KibanaPrivileges(kibanaPrivileges, features), roleCustomizationAnchor.value),
      allSpacesSelected: false,
      canCustomizeSubFeaturePrivileges: (_license$getFeatures$ = license === null || license === void 0 ? void 0 : license.getFeatures().allowSubFeaturePrivileges) !== null && _license$getFeatures$ !== void 0 ? _license$getFeatures$ : false,
      showAdditionalPermissionsMessage: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 527,
        columnNumber: 23
      }
    }))))));
  };
  const canSave = (0, _react.useCallback)(() => {
    var _roleCustomizationAnc3, _form$base, _form$feature;
    if (selectedRoles.length === 0) {
      return false;
    }
    const form = (_roleCustomizationAnc3 = roleCustomizationAnchor.value.kibana[roleCustomizationAnchor.privilegeIndex]) !== null && _roleCustomizationAnc3 !== void 0 ? _roleCustomizationAnc3 : {};
    const formBase = (_form$base = form.base) !== null && _form$base !== void 0 ? _form$base : [];
    const formFeature = (_form$feature = form.feature) !== null && _form$feature !== void 0 ? _form$feature : {};

    // ensure that the form has base privileges or has selected features that are valid
    if (formBase.length === 0 && (Object.keys(formFeature).length === 0 || Object.values(formFeature).every(privileges => privileges.length === 0))) {
      return false;
    }
    return true;
  }, [selectedRoles, roleCustomizationAnchor]);
  const getSaveButton = (0, _react.useCallback)(() => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      disabled: !canSave(),
      isLoading: assigningToRole,
      onClick: () => assignRolesToSpace(),
      "data-test-subj": `space-${isEditOperation.current ? 'update' : 'assign'}-role-create-roles-privilege-button`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 642,
        columnNumber: 7
      }
    }, isEditOperation.current ? _i18n.i18n.translate('xpack.spaces.management.spaceDetails.roles.updateRoleButton', {
      defaultMessage: 'Update role privileges'
    }) : _i18n.i18n.translate('xpack.spaces.management.spaceDetails.roles.assignRoleButton', {
      defaultMessage: 'Assign roles'
    }));
  }, [assignRolesToSpace, assigningToRole, canSave]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 663,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 664,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 665,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "space-assign-role-privilege-form-title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 666,
      columnNumber: 11
    }
  }, isEditOperation.current ? _i18n.i18n.translate('xpack.spaces.management.spaceDetails.roles.assignRoleButton', {
    defaultMessage: 'Edit role privileges for space'
  }) : _i18n.i18n.translate('xpack.spaces.management.spaceDetails.roles.assign.privileges.custom', {
    defaultMessage: 'Assign roles to space'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 680,
      columnNumber: 7
    }
  }, getForm()), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 681,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 682,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 683,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: closeFlyout,
    flush: "left",
    "data-test-subj": "space-assign-role-cancel-roles-privilege-button",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 684,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.spaces.management.spaceDetails.roles.cancelRoleButton', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 695,
      columnNumber: 11
    }
  }, getSaveButton()))));
};
exports.PrivilegesRolesForm = PrivilegesRolesForm;