"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectableSpacesControl = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _common = require("../../../common");
var _space_avatar = require("../../space_avatar");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/spaces/public/copy_saved_objects_to_space/components/selectable_spaces_control.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// No need to wrap LazySpaceAvatar in an error boundary, because it is one of the first chunks loaded when opening Kibana.
const LazySpaceAvatar = /*#__PURE__*/(0, _react2.lazy)(() => (0, _space_avatar.getSpaceAvatarComponent)().then(component => ({
  default: component
})));
const SelectableSpacesControl = props => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (props.spaces.length === 0) {
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingSpinner, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 12
      }
    });
  }
  const disabledIndicator = /*#__PURE__*/_react2.default.createElement(_eui.EuiIconTip, {
    content: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.copyToSpace.selectSpacesControl.disabledTooltip",
      defaultMessage: "The object or a related object already exists in this space.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 9
      }
    }),
    position: "left",
    type: "info",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  });
  const options = props.spaces.map(space => {
    const disabled = props.disabledSpaceIds.has(space.id);
    return {
      label: space.name,
      prepend: /*#__PURE__*/_react2.default.createElement(LazySpaceAvatar, {
        space: space,
        size: 's',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 16
        }
      }),
      // wrapped in a Suspense below
      append: disabled ? disabledIndicator : null,
      checked: props.selectedSpaceIds.includes(space.id) ? 'on' : undefined,
      disabled,
      ['data-space-id']: space.id,
      ['data-test-subj']: `cts-space-selector-row-${space.id}`
    };
  });
  function updateSelectedSpaces(selectedOptions) {
    if (props.disabled) return;
    const selectedSpaceIds = selectedOptions.filter(opt => opt.checked).map(opt => opt['data-space-id']);
    props.onChange(selectedSpaceIds);
  }
  return /*#__PURE__*/_react2.default.createElement(_react2.Suspense, {
    fallback: /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingSpinner, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 25
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSelectable, {
    options: options,
    onChange: newOptions => updateSelectedSpaces(newOptions),
    listProps: {
      bordered: true,
      rowHeight: 40,
      css: (0, _react.css)`
            margin-top: ${euiTheme.size.xs};
          `,
      'data-test-subj': 'cts-form-space-selector'
    },
    searchable: options.length > _common.SPACE_SEARCH_COUNT_THRESHOLD,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }, (list, search) => {
    return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, search, list);
  }));
};
exports.SelectableSpacesControl = SelectableSpacesControl;