"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CopyModeControl = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/spaces/public/copy_saved_objects_to_space/components/copy_mode_control.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const createNewCopiesDisabled = {
  id: 'createNewCopiesDisabled',
  text: _i18n.i18n.translate('xpack.spaces.management.copyToSpace.copyModeControl.createNewCopies.disabledTitle', {
    defaultMessage: 'Check for existing objects'
  }),
  tooltip: _i18n.i18n.translate('xpack.spaces.management.copyToSpace.copyModeControl.createNewCopies.disabledText', {
    defaultMessage: 'Check if objects were previously copied or imported into the space.'
  })
};
const createNewCopiesEnabled = {
  id: 'createNewCopiesEnabled',
  text: _i18n.i18n.translate('xpack.spaces.management.copyToSpace.copyModeControl.createNewCopies.enabledTitle', {
    defaultMessage: 'Create new objects with random IDs'
  }),
  tooltip: _i18n.i18n.translate('xpack.spaces.management.copyToSpace.copyModeControl.createNewCopies.enabledText', {
    defaultMessage: 'Use this option to create one or more copies of the object in the same space.'
  })
};
const overwriteEnabled = {
  id: 'overwriteEnabled',
  label: _i18n.i18n.translate('xpack.spaces.management.copyToSpace.copyModeControl.overwrite.enabledLabel', {
    defaultMessage: 'Automatically overwrite conflicts'
  })
};
const overwriteDisabled = {
  id: 'overwriteDisabled',
  label: _i18n.i18n.translate('xpack.spaces.management.copyToSpace.copyModeControl.overwrite.disabledLabel', {
    defaultMessage: 'Request action on conflict'
  })
};
const includeRelated = {
  id: 'includeRelated',
  text: _i18n.i18n.translate('xpack.spaces.management.copyToSpace.copyModeControl.includeRelated.title', {
    defaultMessage: 'Include related objects'
  }),
  tooltip: _i18n.i18n.translate('xpack.spaces.management.copyToSpace.copyModeControl.includeRelated.text', {
    defaultMessage: 'Copy this object and its related objects. For dashboards, related visualizations, data views, and saved Discover sessions are also copied.'
  })
};
const copyOptionsTitle = _i18n.i18n.translate('xpack.spaces.management.copyToSpace.copyModeControl.copyOptionsTitle', {
  defaultMessage: 'Copy options'
});
const relationshipOptionsTitle = _i18n.i18n.translate('xpack.spaces.management.copyToSpace.copyModeControl.relationshipOptionsTitle', {
  defaultMessage: 'Relationship'
});
const createLabel = ({
  text,
  tooltip
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 97,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 98,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 99,
    columnNumber: 7
  }
}, text)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 101,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
  content: tooltip,
  position: "left",
  type: "info",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 102,
    columnNumber: 7
  }
})));
const CopyModeControl = ({
  initialValues,
  updateSelection
}) => {
  const [createNewCopies, setCreateNewCopies] = (0, _react.useState)(initialValues.createNewCopies);
  const [overwrite, setOverwrite] = (0, _react.useState)(initialValues.overwrite);
  const onChange = partial => {
    if (partial.createNewCopies !== undefined) {
      setCreateNewCopies(partial.createNewCopies);
    } else if (partial.overwrite !== undefined) {
      setOverwrite(partial.overwrite);
    }
    updateSelection({
      createNewCopies,
      overwrite,
      ...partial
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormFieldset, {
    legend: {
      children: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 125,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 126,
          columnNumber: 15
        }
      }, copyOptionsTitle))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    id: createNewCopiesEnabled.id,
    label: createLabel(createNewCopiesEnabled),
    checked: createNewCopies,
    onChange: () => onChange({
      createNewCopies: true
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    id: createNewCopiesDisabled.id,
    label: createLabel(createNewCopiesDisabled),
    checked: !createNewCopies,
    onChange: () => onChange({
      createNewCopies: false
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    options: [overwriteEnabled, overwriteDisabled],
    idSelected: overwrite ? overwriteEnabled.id : overwriteDisabled.id,
    onChange: id => onChange({
      overwrite: id === overwriteEnabled.id
    }),
    disabled: createNewCopies,
    "data-test-subj": 'cts-copyModeControl-overwriteRadioGroup',
    name: "overwriteOption",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormFieldset, {
    legend: {
      children: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 162,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 163,
          columnNumber: 15
        }
      }, relationshipOptionsTitle))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    id: includeRelated.id,
    label: createLabel(includeRelated),
    checkableType: "checkbox",
    checked: true,
    onChange: () => {} // noop
    ,
    disabled: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 9
    }
  })));
};
exports.CopyModeControl = CopyModeControl;