"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnapshotSearchBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _components = require("../../../../components");
var _lib = require("../../../../lib");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/sections/home/snapshot_list/components/snapshot_search_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SEARCH_DEBOUNCE_VALUE_MS = 200;
const onlyOneClauseMessage = _i18n.i18n.translate('xpack.snapshotRestore.snapshotList.searchBar.onlyOneClauseMessage', {
  defaultMessage: 'You can only use one clause in the search bar'
});
// for now limit the search bar to snapshot, repository and policyName queries
const searchSchema = {
  strict: true,
  fields: {
    snapshot: {
      type: 'string'
    },
    repository: {
      type: 'string'
    },
    policyName: {
      type: 'string'
    }
  }
};
const SnapshotSearchBar = ({
  listParams,
  setListParams,
  reload,
  selectedItems,
  onSnapshotDeleted,
  repositories
}) => {
  const [cachedListParams, setCachedListParams] = (0, _react.useState)(listParams);
  // send the request after the user has stopped typing
  (0, _useDebounce.default)(() => {
    setListParams(cachedListParams);
  }, SEARCH_DEBOUNCE_VALUE_MS, [cachedListParams]);
  const deleteButton = selectedItems.length ? /*#__PURE__*/_react.default.createElement(_components.SnapshotDeleteProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 5
    }
  }, deleteSnapshotPrompt => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: () => deleteSnapshotPrompt(selectedItems.map(({
        snapshot,
        repository
      }) => ({
        snapshot,
        repository
      })), onSnapshotDeleted),
      color: "danger",
      "data-test-subj": "srSnapshotListBulkDeleteActionButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.snapshotList.table.deleteSnapshotButton",
      defaultMessage: "Delete {count, plural, one {snapshot} other {snapshots}}",
      values: {
        count: selectedItems.length
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 13
      }
    }));
  }) : [];
  const searchFilters = [{
    type: 'field_value_selection',
    field: 'repository',
    name: _i18n.i18n.translate('xpack.snapshotRestore.snapshotList.table.repositoryFilterLabel', {
      defaultMessage: 'Repository'
    }),
    operator: 'exact',
    multiSelect: false,
    options: repositories.map(repository => ({
      value: repository,
      view: repository
    }))
  }];
  const reloadButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "success",
    iconType: "refresh",
    onClick: reload,
    "data-test-subj": "reloadButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.snapshotList.table.reloadSnapshotsButton",
    defaultMessage: "Reload",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 7
    }
  }));
  const [query, setQuery] = (0, _react.useState)((0, _lib.getQueryFromListParams)(listParams, searchSchema));
  const [error, setError] = (0, _react.useState)(null);
  const onSearchBarChange = args => {
    const {
      query: changedQuery,
      error: queryError
    } = args;
    if (changedQuery) {
      changedQuery.text = (0, _lib.escapeString)(changedQuery.text);
      setError(null);
      setQuery(changedQuery);
      if (changedQuery.ast.clauses.length > 1) {
        setError({
          name: onlyOneClauseMessage,
          message: onlyOneClauseMessage
        });
      } else {
        setCachedListParams((0, _lib.getListParams)(listParams, changedQuery));
      }
    } else if (queryError) {
      setError(queryError);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    filters: searchFilters,
    query: query,
    onChange: onSearchBarChange,
    toolsLeft: deleteButton,
    toolsRight: reloadButton,
    box: {
      schema: searchSchema,
      incremental: true,
      'data-test-subj': 'snapshotListSearch'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 7
    }
  }), error ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "snapshotListSearchError",
    iconType: "warning",
    role: "alert",
    color: "danger",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.snapshotList.searchBar.invalidSearchMessage",
      defaultMessage: "Invalid search: {errorMessage}",
      values: {
        errorMessage: error.message
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 11
    }
  })) : null);
};
exports.SnapshotSearchBar = SnapshotSearchBar;