"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnapshotRestoreHome = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _eui = require("@elastic/eui");
var _constants = require("../../constants");
var _app_context = require("../../app_context");
var _navigation = require("../../services/navigation");
var _repository_list = require("./repository_list");
var _snapshot_list = require("./snapshot_list");
var _restore_list = require("./restore_list");
var _policy_list = require("./policy_list");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/sections/home/home.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SnapshotRestoreHome = ({
  match: {
    params: {
      section
    }
  },
  history
}) => {
  const {
    slm_ui: slmUi
  } = (0, _app_context.useConfig)();
  const {
    docLinks
  } = (0, _app_context.useCore)();
  const tabs = [{
    id: 'snapshots',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.home.snapshotsTabTitle",
      defaultMessage: "Snapshots",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 9
      }
    })
  }, {
    id: 'repositories',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.home.repositoriesTabTitle",
      defaultMessage: "Repositories",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 9
      }
    })
  }, {
    id: 'restore_status',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.home.restoreTabTitle",
      defaultMessage: "Restore Status",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 9
      }
    })
  }];
  if (slmUi.enabled) {
    tabs.splice(2, 0, {
      id: 'policies',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.home.policiesTabTitle",
        defaultMessage: "Policies",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 75,
          columnNumber: 9
        }
      })
    });
  }
  const onSectionChange = newSection => {
    history.push(encodeURI(`${_constants.BASE_PATH}/${encodeURIComponent(newSection)}`));
  };

  // Set breadcrumb and page title
  (0, _react.useEffect)(() => {
    _navigation.breadcrumbService.setBreadcrumbs(section || 'home');
    _navigation.docTitleService.setTitle(section || 'home');
  }, [section]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    bottomBorder: true,
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "appTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.home.snapshotRestoreTitle",
      defaultMessage: "Snapshot and Restore",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 13
      }
    })),
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      href: docLinks.links.snapshotRestore.guide,
      target: "_blank",
      iconType: "question",
      "data-test-subj": "documentationLink",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.home.snapshotRestoreDocsLinkText",
      defaultMessage: "Snapshot and Restore docs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 13
      }
    }))],
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.home.snapshotRestoreDescription",
      defaultMessage: "Use repositories to store and recover backups of your Elasticsearch indices and clusters.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 11
      }
    }),
    tabs: tabs.map(tab => ({
      onClick: () => onSectionChange(tab.id),
      isSelected: tab.id === section,
      key: tab.id,
      'data-test-subj': tab.id.toLowerCase() + '_tab',
      label: tab.name
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: `${_constants.BASE_PATH}/repositories/:repositoryName*`,
    component: _repository_list.RepositoryList,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: `${_constants.BASE_PATH}/snapshots`,
    component: _snapshot_list.SnapshotList,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: `${_constants.BASE_PATH}/snapshots/:repositoryName*/:snapshotId`,
    component: _snapshot_list.SnapshotList,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: `${_constants.BASE_PATH}/restore_status`,
    component: _restore_list.RestoreList,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: `${_constants.BASE_PATH}/policies/:policyName*`,
    component: _policy_list.PolicyList,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 9
    }
  })));
};
exports.SnapshotRestoreHome = SnapshotRestoreHome;