"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RepositoryFormStepOne = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _common = require("../../../../common");
var _shared_imports = require("../../../shared_imports");
var _http = require("../../services/http");
var _text = require("../../services/text");
var _ = require("..");
var _app_context = require("../../app_context");
var _type_to_doc_url = require("../../lib/type_to_doc_url");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/components/repository_form/step_one.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RepositoryFormStepOne = ({
  repository,
  onNext,
  updateRepository,
  validation
}) => {
  // Load repository types
  const {
    error: repositoryTypesError,
    isLoading: repositoryTypesLoading,
    data: repositoryTypes = []
  } = (0, _http.useLoadRepositoryTypes)();
  const {
    docLinks
  } = (0, _app_context.useCore)();
  const hasValidationErrors = !validation.isValid;
  const onTypeChange = newType => {
    if (repository.type === _common.REPOSITORY_TYPES.source) {
      updateRepository({
        settings: {
          delegateType: newType
        }
      });
    } else {
      updateRepository({
        type: newType,
        settings: {}
      });
    }
  };
  const snapshotRepoDocLink = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: docLinks.links.plugins.snapshotRestoreRepos,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.repositoryForm.fields.typePluginsDocLinkText",
    defaultMessage: "Learn more about repository types.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }));
  const renderNameField = () => /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.fields.nameDescriptionTitle",
      defaultMessage: "Repository name",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 13
      }
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.fields.nameDescription",
      defaultMessage: "A unique name for the repository.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 9
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.fields.nameLabel",
      defaultMessage: "Name",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 11
      }
    }),
    isInvalid: Boolean(hasValidationErrors && validation.errors.name),
    error: validation.errors.name,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    isInvalid: Boolean(hasValidationErrors && validation.errors.name),
    defaultValue: repository.name,
    fullWidth: true,
    onChange: e => {
      updateRepository({
        name: e.target.value
      });
    },
    "data-test-subj": "nameInput",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  })));
  const renderTypeCard = (type, index) => {
    const isSelectedType = (repository.type === _common.REPOSITORY_TYPES.source ? repository.settings.delegateType : repository.type) === type;
    const displayName = _text.textService.getRepositoryTypeName(type);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: index,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
      title: displayName,
      icon: /*#__PURE__*/_react.default.createElement(_.RepositoryTypeLogo, {
        type: type,
        size: "l",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 144,
          columnNumber: 17
        }
      }),
      description: /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 145,
          columnNumber: 24
        }
      }) /* EuiCard requires `description` */,
      footer: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        href: (0, _type_to_doc_url.getRepositoryTypeDocUrl)(docLinks, type),
        target: "_blank",
        size: "xs",
        iconType: "info",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 147,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.repositoryForm.fields.typeDocsLinkText",
        defaultMessage: "Learn more",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 153,
          columnNumber: 15
        }
      })),
      selectable: {
        onClick: () => onTypeChange(type),
        isSelected: isSelectedType
      },
      "data-test-subj": `${type}RepositoryType`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 9
      }
    }));
  };
  const renderTypes = () => {
    if (repositoryTypesError) {
      return /*#__PURE__*/_react.default.createElement(_shared_imports.SectionError, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.snapshotRestore.repositoryForm.loadingRepositoryTypesErrorMessage",
          defaultMessage: "Error loading repository types",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 174,
            columnNumber: 13
          }
        }),
        error: repositoryTypesError,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 172,
          columnNumber: 9
        }
      });
    }
    if (repositoryTypesLoading) {
      return /*#__PURE__*/_react.default.createElement(_.SectionLoading, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 186,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.repositoryForm.loadingRepositoryTypesDescription",
        defaultMessage: "Loading repository types\u2026",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 187,
          columnNumber: 11
        }
      }));
    }
    if (!repositoryTypes.length) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.snapshotRestore.repositoryForm.noRepositoryTypesErrorTitle",
          defaultMessage: "No repository types available",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 199,
            columnNumber: 13
          }
        }),
        color: "warning",
        "data-test-subj": "noRepositoryTypesError",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 197,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.repositoryForm.noRepositoryTypesErrorMessage",
        defaultMessage: "You can install plugins to enable different repository types. {docLink}",
        values: {
          docLink: snapshotRepoDocLink
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 207,
          columnNumber: 11
        }
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
      columns: 4,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 219,
        columnNumber: 7
      }
    }, repositoryTypes.map((type, index) => renderTypeCard(type, index)));
  };
  const renderTypeField = () => {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 227,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 228,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 229,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.fields.typeDescriptionTitle",
      defaultMessage: "Repository type",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 230,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 236,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      id: "repositoryTypeDescription",
      size: "s",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 237,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.fields.defaultTypeDescription",
      defaultMessage: "Storage location for your snapshots. {docLink}",
      values: {
        docLink: snapshotRepoDocLink
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 238,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      describedByIds: ['repositoryTypeDescription'],
      fullWidth: true,
      isInvalid: Boolean(hasValidationErrors && validation.errors.type),
      error: validation.errors.type,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 246,
        columnNumber: 9
      }
    }, renderTypes()), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 254,
        columnNumber: 9
      }
    }));
  };
  const renderSourceOnlyToggle = () => /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 262,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 263,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.fields.sourceOnlyDescriptionTitle",
      defaultMessage: "Source-only snapshots",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 264,
        columnNumber: 13
      }
    }))),
    description: /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 272,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.fields.sourceOnlyDescription",
      defaultMessage: "Creates source-only snapshots that take up to 50% less space. {docLink}",
      values: {
        docLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: (0, _type_to_doc_url.getRepositoryTypeDocUrl)(docLinks, _common.REPOSITORY_TYPES.source),
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 278,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.snapshotRestore.repositoryForm.fields.sourceOnlyDocLinkText",
          defaultMessage: "Learn more about source-only repositories.",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 282,
            columnNumber: 19
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 273,
        columnNumber: 11
      }
    })),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.fields.sourceOnlyLabel",
      defaultMessage: "Source-only snapshots",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 297,
        columnNumber: 13
      }
    }),
    checked: repository.type === _common.REPOSITORY_TYPES.source,
    onChange: e => {
      if (e.target.checked) {
        updateRepository({
          type: _common.REPOSITORY_TYPES.source,
          settings: {
            ...repository.settings,
            delegateType: repository.type
          }
        });
      } else {
        const {
          settings: {
            delegateType,
            ...rest
          }
        } = repository;
        updateRepository({
          type: delegateType || null,
          settings: rest
        });
      }
    },
    "data-test-subj": "sourceOnlyToggle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 9
    }
  })));
  const renderActions = () => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    onClick: onNext,
    fill: true,
    iconType: "arrowRight",
    iconSide: "right",
    "data-test-subj": "nextButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 329,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.repositoryForm.nextButtonLabel",
    defaultMessage: "Next",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 337,
      columnNumber: 7
    }
  }));
  const renderFormValidationError = () => {
    if (!hasValidationErrors) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 349,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.repositoryForm.validationErrorTitle",
        defaultMessage: "Fix errors before continuing.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 352,
          columnNumber: 13
        }
      }),
      role: "alert",
      color: "danger",
      "data-test-subj": "repositoryFormError",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 350,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 361,
        columnNumber: 9
      }
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 367,
      columnNumber: 5
    }
  }, renderNameField(), renderTypeField(), renderSourceOnlyToggle(), renderFormValidationError(), renderActions());
};
exports.RepositoryFormStepOne = RepositoryFormStepOne;