"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.App = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/core/public");
var _common = require("../../common");
var _shared_imports = require("../shared_imports");
var _components = require("./components");
var _constants = require("./constants");
var _sections = require("./sections");
var _app_context = require("./app_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/app.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const App = () => {
  const {
    slm_ui: slmUi
  } = (0, _app_context.useConfig)();
  const {
    apiError
  } = (0, _shared_imports.useAuthorizationContext)();
  const sections = ['repositories', 'snapshots', 'restore_status'];
  if (slmUi.enabled) {
    sections.push('policies');
  }
  const sectionsRegex = sections.join('|');
  return apiError ? /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.app.checkingPrivilegesErrorMessage",
      defaultMessage: "Error fetching user privileges from the server.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 9
      }
    }),
    error: apiError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_shared_imports.WithPrivileges, {
    privileges: _common.APP_REQUIRED_CLUSTER_PRIVILEGES.map(name => `cluster.${name}`),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, ({
    isLoading,
    hasPrivileges,
    privilegesMissing
  }) => isLoading ? /*#__PURE__*/_react.default.createElement(_components.PageLoading, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.app.checkingPrivilegesDescription",
    defaultMessage: "Checking privileges\u2026",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 13
    }
  })) : hasPrivileges ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "snapshotRestoreApp",
    className: _public.APP_WRAPPER_CLASS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: "/add_repository",
    component: _sections.RepositoryAdd,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: "/edit_repository/:name*",
    component: _sections.RepositoryEdit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: `/:section(${sectionsRegex})/:repositoryName?/:snapshotId*`,
    component: _sections.SnapshotRestoreHome,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    exact: true,
    from: "/restore/:repositoryName",
    to: "/snapshots",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: "/restore/:repositoryName/:snapshotId*",
    component: _sections.RestoreSnapshot,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 15
    }
  }), slmUi.enabled && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: "/add_policy",
    component: _sections.PolicyAdd,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 33
    }
  }), slmUi.enabled && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: "/edit_policy/:name*",
    component: _sections.PolicyEdit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 33
    }
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    from: "/",
    to: `/${_constants.DEFAULT_SECTION}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    from: "",
    to: `/${_constants.DEFAULT_SECTION}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 15
    }
  }))) : /*#__PURE__*/_react.default.createElement(_shared_imports.NotAuthorizedSection, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.app.deniedPrivilegeTitle",
      defaultMessage: "You're missing cluster privileges",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 15
      }
    }),
    message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.app.deniedPrivilegeDescription",
      defaultMessage: "To use Snapshot and Restore, you must have {privilegesCount, plural, one {this cluster privilege} other {these cluster privileges}}: {missingPrivileges}.",
      values: {
        missingPrivileges: privilegesMissing.cluster.join(', '),
        privilegesCount: privilegesMissing.cluster.length
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  }));
};
exports.App = App;