"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTransformQueryComposite = getTransformQueryComposite;
var _queries = require("../../utils/queries");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getTransformQueryComposite(transform) {
  let transformQueryString = '';
  if (transform) {
    var _transform$pivot$grou, _transform$pivot, _transform$pivot2;
    const pivotGroupBy = (_transform$pivot$grou = (_transform$pivot = transform.pivot) === null || _transform$pivot === void 0 ? void 0 : _transform$pivot.group_by) !== null && _transform$pivot$grou !== void 0 ? _transform$pivot$grou : {};
    const transformQuery = (0, _queries.createEsParams)({
      size: 0,
      query: transform.source.query,
      runtime_mappings: transform.source.runtime_mappings,
      aggs: {
        groupBy: {
          composite: {
            sources: Object.keys(pivotGroupBy).map(key => ({
              [key]: pivotGroupBy[key]
            }))
          },
          aggs: transform === null || transform === void 0 ? void 0 : (_transform$pivot2 = transform.pivot) === null || _transform$pivot2 === void 0 ? void 0 : _transform$pivot2.aggregations
        }
      }
    });
    transformQueryString = `POST ${transform.source.index}/_search\n${JSON.stringify(transformQuery, null, 2)}`;
  }
  return transformQueryString;
}