"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransformGenerator = void 0;
var _sloSchema = require("@kbn/slo-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TransformGenerator {
  constructor(spaceId, dataViewService, isServerless = false) {
    this.spaceId = spaceId;
    this.dataViewService = dataViewService;
    this.isServerless = isServerless;
  }
  buildCommonRuntimeMappings(dataView) {
    var _dataView$getRuntimeM, _dataView$getRuntimeM2;
    return (_dataView$getRuntimeM = dataView === null || dataView === void 0 ? void 0 : (_dataView$getRuntimeM2 = dataView.getRuntimeMappings) === null || _dataView$getRuntimeM2 === void 0 ? void 0 : _dataView$getRuntimeM2.call(dataView)) !== null && _dataView$getRuntimeM !== void 0 ? _dataView$getRuntimeM : {};
  }
  buildDescription(slo) {
    return `Rolled-up SLI data for SLO: ${slo.name} [id: ${slo.id}, revision: ${slo.revision}]`;
  }
  buildCommonGroupBy(slo, sourceIndexTimestampField = '@timestamp', extraGroupByFields = {}) {
    let fixedInterval = '1m';
    if (_sloSchema.timeslicesBudgetingMethodSchema.is(slo.budgetingMethod)) {
      fixedInterval = slo.objective.timesliceWindow.format();
    }
    const groups = [slo.groupBy].flat().filter(group => !!group);
    const groupings = !groups.includes(_sloSchema.ALL_VALUE) && groups.length ? groups.reduce((acc, field) => {
      return {
        ...acc,
        [`slo.groupings.${field}`]: {
          terms: {
            field
          }
        }
      };
    }, {}) : {};
    return {
      ...groupings,
      ...extraGroupByFields,
      // @timestamp field defined in the destination index
      '@timestamp': {
        date_histogram: {
          field: sourceIndexTimestampField,
          // timestamp field defined in the source index
          fixed_interval: fixedInterval
        }
      }
    };
  }
  async getIndicatorDataView(dataViewId) {
    let dataView;
    if (dataViewId) {
      try {
        dataView = await this.dataViewService.get(dataViewId);
      } catch (e) {
        // If the data view is not found, we will continue without it
      }
    }
    return dataView;
  }
  buildSettings(slo, sourceIndexTimestampField = '@timestamp') {
    return {
      frequency: slo.settings.frequency.format(),
      sync_delay: slo.settings.syncDelay.format(),
      // 8.17: use settings.syncField if truthy or default to sourceIndexTimestampField which is the indicator timestampField
      sync_field: !!slo.settings.syncField ? slo.settings.syncField : sourceIndexTimestampField
    };
  }
}
exports.TransformGenerator = TransformGenerator;