"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetSLOSuggestions = void 0;
var _saved_objects = require("../saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class GetSLOSuggestions {
  constructor(soClient) {
    this.soClient = soClient;
  }
  async execute() {
    var _ref, _tagsAggs$buckets$map, _tagsAggs$buckets;
    const findResponse = await this.soClient.find({
      type: _saved_objects.SO_SLO_TYPE,
      perPage: 0,
      aggs: {
        tagsAggs: {
          terms: {
            field: `${_saved_objects.SO_SLO_TYPE}.attributes.tags`,
            size: 10000
          }
        }
      }
    });
    const {
      tagsAggs
    } = (_ref = findResponse === null || findResponse === void 0 ? void 0 : findResponse.aggregations) !== null && _ref !== void 0 ? _ref : {};
    return {
      tags: (_tagsAggs$buckets$map = tagsAggs === null || tagsAggs === void 0 ? void 0 : (_tagsAggs$buckets = tagsAggs.buckets) === null || _tagsAggs$buckets === void 0 ? void 0 : _tagsAggs$buckets.map(({
        key,
        doc_count: count
      }) => ({
        label: key,
        value: key,
        count
      }))) !== null && _tagsAggs$buckets$map !== void 0 ? _tagsAggs$buckets$map : []
    };
  }
}
exports.GetSLOSuggestions = GetSLOSuggestions;