"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSloClientWithRequest = getSloClientWithRequest;
var _lodash = require("lodash");
var _slo_settings = require("../services/slo_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getSloClientWithRequest({
  esClient,
  soClient
}) {
  const getSummaryIndicesOnce = (0, _lodash.once)(async () => {
    const settings = await (0, _slo_settings.getSloSettings)(soClient);
    const {
      indices
    } = await (0, _slo_settings.getSummaryIndices)(esClient, settings);
    return indices;
  });
  return {
    getSummaryIndices: async () => {
      return await getSummaryIndicesOnce();
    }
  };
}