"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertSliApmParamsToApmAppDeeplinkUrl = convertSliApmParamsToApmAppDeeplinkUrl;
var _sloSchema = require("@kbn/slo-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function convertSliApmParamsToApmAppDeeplinkUrl(slo) {
  if (!_sloSchema.apmTransactionDurationIndicatorSchema.is(slo.indicator) && !_sloSchema.apmTransactionErrorRateIndicatorSchema.is(slo.indicator)) {
    return undefined;
  }
  const {
    indicator: {
      params: {
        environment,
        filter,
        service,
        transactionName,
        transactionType
      }
    },
    timeWindow: {
      duration
    },
    groupBy
  } = slo;
  const qs = new URLSearchParams('comparisonEnabled=true');
  if (environment) {
    qs.append('environment', environment === _sloSchema.ALL_VALUE ? 'ENVIRONMENT_ALL' : environment);
  }
  if (transactionType) {
    qs.append('transactionType', transactionType === _sloSchema.ALL_VALUE ? '' : transactionType);
  }
  if (duration) {
    qs.append('rangeFrom', `now-${duration}`);
    qs.append('rangeTo', 'now');
  }
  const kueryParams = [];
  if (transactionName && transactionName !== _sloSchema.ALL_VALUE) {
    kueryParams.push(`transaction.name : "${transactionName}"`);
  }
  if (filter && _sloSchema.kqlQuerySchema.is(filter) && filter.length > 0) {
    kueryParams.push(filter);
  }
  if (groupBy !== _sloSchema.ALL_VALUE && 'instanceId' in slo && slo.instanceId !== _sloSchema.ALL_VALUE) {
    kueryParams.push(`${groupBy} : "${slo.instanceId}"`);
  }
  if (kueryParams.length > 0) {
    qs.append('kuery', kueryParams.join(' and '));
  }
  return `/app/apm/services/${service}/overview?${qs.toString()}`;
}