"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SLO_PAGE_ID = void 0;
exports.SlosPage = SlosPage;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-shared-plugin/public");
var _slos_overview = require("./components/slos_overview/slos_overview");
var _paths = require("../../../common/locators/paths");
var _header_menu = require("../../components/header_menu/header_menu");
var _slo_outdated_callout = require("../../components/slo/slo_outdated_callout");
var _use_fetch_slo_list = require("../../hooks/use_fetch_slo_list");
var _use_license = require("../../hooks/use_license");
var _use_permissions = require("../../hooks/use_permissions");
var _use_plugin_context = require("../../hooks/use_plugin_context");
var _use_kibana = require("../../hooks/use_kibana");
var _create_slo_btn = require("./components/common/create_slo_btn");
var _slo_list = require("./components/slo_list");
var _slo_list_search_bar = require("./components/slo_list_search_bar");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slos/slos.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SLO_PAGE_ID = exports.SLO_PAGE_ID = 'slo-page-container';
function SlosPage() {
  const {
    application: {
      navigateToUrl
    },
    http: {
      basePath
    },
    serverless
  } = (0, _use_kibana.useKibana)().services;
  const {
    ObservabilityPageTemplate
  } = (0, _use_plugin_context.usePluginContext)();
  const {
    hasAtLeast
  } = (0, _use_license.useLicense)();
  const {
    data: permissions
  } = (0, _use_permissions.usePermissions)();
  const {
    isLoading,
    isError,
    data: sloList
  } = (0, _use_fetch_slo_list.useFetchSloList)({
    perPage: 0
  });
  const {
    total
  } = sloList !== null && sloList !== void 0 ? sloList : {
    total: 0
  };
  (0, _public.useBreadcrumbs)([{
    href: basePath.prepend(_paths.paths.slos),
    text: _i18n.i18n.translate('xpack.slo.breadcrumbs.slosLinkText', {
      defaultMessage: 'SLOs'
    }),
    deepLinkId: 'slo'
  }], {
    serverless
  });
  (0, _react.useEffect)(() => {
    if (!isLoading && total === 0 || hasAtLeast('platinum') === false || isError) {
      navigateToUrl(basePath.prepend(_paths.paths.slosWelcome));
    }
    if ((permissions === null || permissions === void 0 ? void 0 : permissions.hasAllReadRequested) === false) {
      navigateToUrl(basePath.prepend(_paths.paths.slosWelcome));
    }
  }, [basePath, hasAtLeast, isError, isLoading, navigateToUrl, total, permissions]);
  return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    "data-test-subj": "slosPage",
    pageHeader: {
      pageTitle: _i18n.i18n.translate('xpack.slo.slosPage.', {
        defaultMessage: 'SLOs'
      }),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_create_slo_btn.CreateSloBtn, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 68,
          columnNumber: 26
        }
      })]
    },
    topSearchBar: /*#__PURE__*/_react.default.createElement(_slo_list_search_bar.SloListSearchBar, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 21
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_header_menu.HeaderMenu, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_slo_outdated_callout.SloOutdatedCallout, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_slos_overview.SLOsOverview, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_slo_list.SloList, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }));
}