"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloItemActions = SloItemActions;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireDefault(require("react"));
var _use_kibana = require("../../../hooks/use_kibana");
var _use_permissions = require("../../../hooks/use_permissions");
var _use_slo_actions = require("../../slo_details/hooks/use_slo_actions");
var _action_modal = require("../../../context/action_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slos/components/slo_item_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function IconPanel({
  children
}) {
  const shadow = (0, _eui.useEuiShadow)('s');
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    color: "plain",
    element: "button",
    grow: false,
    paddingSize: "none",
    hasShadow: false,
    css: (0, _react.css)`
        ${shadow}
      `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, children);
}
function SloItemActions({
  slo,
  rules,
  isActionsPopoverOpen,
  setIsActionsPopoverOpen,
  setIsAddRuleFlyoutOpen,
  setIsEditRuleFlyoutOpen,
  setDashboardAttachmentReady,
  btnProps
}) {
  var _rules$length;
  const {
    application: {
      navigateToUrl
    },
    executionContext
  } = (0, _use_kibana.useKibana)().services;
  const executionContextName = executionContext.get().name;
  const isDashboardContext = executionContextName === 'dashboards';
  const {
    data: permissions
  } = (0, _use_permissions.usePermissions)();
  const {
    triggerAction
  } = (0, _action_modal.useActionModal)();
  const {
    handleNavigateToRules,
    sloEditUrl,
    remoteDeleteUrl,
    remoteResetUrl,
    remoteEnableUrl,
    remoteDisableUrl,
    sloDetailsUrl
  } = (0, _use_slo_actions.useSloActions)({
    slo,
    rules,
    setIsEditRuleFlyoutOpen,
    setIsActionsPopoverOpen
  });
  const handleClickActions = () => {
    setIsActionsPopoverOpen(!isActionsPopoverOpen);
  };
  const handleViewDetails = () => {
    navigateToUrl(sloDetailsUrl);
  };
  const handleClone = () => {
    triggerAction({
      type: 'clone',
      item: slo,
      onConfirm: () => setIsActionsPopoverOpen(false)
    });
  };
  const handleDelete = () => {
    if (!!remoteDeleteUrl) {
      window.open(remoteDeleteUrl, '_blank');
    } else {
      triggerAction({
        type: 'delete',
        item: slo,
        onConfirm: () => setIsActionsPopoverOpen(false)
      });
    }
  };
  const handleReset = () => {
    if (!!remoteResetUrl) {
      window.open(remoteResetUrl, '_blank');
    } else {
      triggerAction({
        type: 'reset',
        item: slo,
        onConfirm: () => setIsActionsPopoverOpen(false)
      });
    }
  };
  const handleEnable = () => {
    if (!!remoteEnableUrl) {
      window.open(remoteEnableUrl, '_blank');
    } else {
      triggerAction({
        type: 'enable',
        item: slo,
        onConfirm: () => setIsActionsPopoverOpen(false)
      });
    }
  };
  const handleDisable = () => {
    if (!!remoteDisableUrl) {
      window.open(remoteDisableUrl, '_blank');
    } else {
      triggerAction({
        type: 'disable',
        item: slo,
        onConfirm: () => setIsActionsPopoverOpen(false)
      });
    }
  };
  const handleCreateRule = () => {
    setIsActionsPopoverOpen(false);
    setIsAddRuleFlyoutOpen(true);
  };
  const handleAddToDashboard = () => {
    setIsActionsPopoverOpen(false);
    if (setDashboardAttachmentReady) {
      setDashboardAttachmentReady(true);
    }
  };
  const btn = /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
    "data-test-subj": "o11ySloListItemButton",
    "aria-label": _i18n.i18n.translate('xpack.slo.item.actions.button', {
      defaultMessage: 'Actions'
    }),
    color: "text",
    disabled: !slo.summary,
    display: "empty",
    iconType: "boxesVertical",
    size: "s",
    onClick: handleClickActions
  }, btnProps, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 5
    }
  }));
  const isRemote = !!slo.remote;
  const hasUndefinedRemoteKibanaUrl = !!slo.remote && slo.remote.kibanaUrl === '';
  const showRemoteLinkIcon = isRemote ? /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    type: "popout",
    size: "s",
    css: {
      marginLeft: '10px'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 5
    }
  }) : null;
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downLeft",
    button: btnProps ? /*#__PURE__*/_react2.default.createElement(IconPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 26
      }
    }, btn) : btn,
    panelPaddingSize: "m",
    closePopover: handleClickActions,
    isOpen: isActionsPopoverOpen,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiContextMenuPanel, {
    size: "m",
    items: [/*#__PURE__*/_react2.default.createElement(_eui.EuiContextMenuItem, {
      key: "view",
      icon: "inspect",
      onClick: handleViewDetails,
      "data-test-subj": "sloActionsView",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.slo.item.actions.details', {
      defaultMessage: 'Details'
    })), /*#__PURE__*/_react2.default.createElement(_eui.EuiContextMenuItem, {
      key: "edit",
      icon: "pencil",
      disabled: !(permissions !== null && permissions !== void 0 && permissions.hasAllWriteRequested) || hasUndefinedRemoteKibanaUrl,
      href: sloEditUrl,
      target: isRemote ? '_blank' : undefined,
      toolTipContent: hasUndefinedRemoteKibanaUrl ? NOT_AVAILABLE_FOR_UNDEFINED_REMOTE_KIBANA_URL : '',
      "data-test-subj": "sloActionsEdit",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 201,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.slo.item.actions.edit', {
      defaultMessage: 'Edit'
    }), showRemoteLinkIcon), /*#__PURE__*/_react2.default.createElement(_eui.EuiContextMenuItem, {
      key: "createRule",
      icon: "bell",
      disabled: !(permissions !== null && permissions !== void 0 && permissions.hasAllWriteRequested) || isRemote,
      onClick: handleCreateRule,
      "data-test-subj": "sloActionsCreateRule",
      toolTipContent: isRemote ? NOT_AVAILABLE_FOR_REMOTE : '',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 217,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.slo.item.actions.createRule', {
      defaultMessage: 'Create new alert rule'
    })), /*#__PURE__*/_react2.default.createElement(_eui.EuiContextMenuItem, {
      key: "manageRules",
      icon: "gear",
      disabled: !(permissions !== null && permissions !== void 0 && permissions.hasAllWriteRequested) || hasUndefinedRemoteKibanaUrl,
      onClick: handleNavigateToRules,
      "data-test-subj": "sloActionsManageRules",
      toolTipContent: hasUndefinedRemoteKibanaUrl ? NOT_AVAILABLE_FOR_UNDEFINED_REMOTE_KIBANA_URL : '',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 229,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.slo.item.actions.manageBurnRateRules', {
      defaultMessage: 'Manage burn rate {count, plural, one {rule} other {rules}}',
      values: {
        count: (_rules$length = rules === null || rules === void 0 ? void 0 : rules.length) !== null && _rules$length !== void 0 ? _rules$length : 0
      }
    }), showRemoteLinkIcon), slo.enabled ? /*#__PURE__*/_react2.default.createElement(_eui.EuiContextMenuItem, {
      key: "disable",
      icon: "stop",
      disabled: !(permissions !== null && permissions !== void 0 && permissions.hasAllWriteRequested) || hasUndefinedRemoteKibanaUrl,
      onClick: handleDisable,
      toolTipContent: hasUndefinedRemoteKibanaUrl ? NOT_AVAILABLE_FOR_UNDEFINED_REMOTE_KIBANA_URL : '',
      "data-test-subj": "sloActionsDisable",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 246,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.slo.item.actions.disable', {
      defaultMessage: 'Disable'
    }), showRemoteLinkIcon) : /*#__PURE__*/_react2.default.createElement(_eui.EuiContextMenuItem, {
      key: "enable",
      icon: "play",
      disabled: !(permissions !== null && permissions !== void 0 && permissions.hasAllWriteRequested) || hasUndefinedRemoteKibanaUrl,
      onClick: handleEnable,
      toolTipContent: hasUndefinedRemoteKibanaUrl ? NOT_AVAILABLE_FOR_UNDEFINED_REMOTE_KIBANA_URL : '',
      "data-test-subj": "sloActionsEnable",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 260,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.slo.item.actions.enable', {
      defaultMessage: 'Enable'
    }), showRemoteLinkIcon), /*#__PURE__*/_react2.default.createElement(_eui.EuiContextMenuItem, {
      key: "clone",
      disabled: !(permissions !== null && permissions !== void 0 && permissions.hasAllWriteRequested) || hasUndefinedRemoteKibanaUrl,
      icon: "copy",
      onClick: handleClone,
      "data-test-subj": "sloActionsClone",
      toolTipContent: hasUndefinedRemoteKibanaUrl ? NOT_AVAILABLE_FOR_UNDEFINED_REMOTE_KIBANA_URL : '',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 274,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.slo.item.actions.clone', {
      defaultMessage: 'Clone'
    }), showRemoteLinkIcon), /*#__PURE__*/_react2.default.createElement(_eui.EuiContextMenuItem, {
      key: "delete",
      icon: "trash",
      disabled: !(permissions !== null && permissions !== void 0 && permissions.hasAllWriteRequested) || hasUndefinedRemoteKibanaUrl,
      onClick: handleDelete,
      toolTipContent: hasUndefinedRemoteKibanaUrl ? NOT_AVAILABLE_FOR_UNDEFINED_REMOTE_KIBANA_URL : '',
      "data-test-subj": "sloActionsDelete",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 287,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.slo.item.actions.delete', {
      defaultMessage: 'Delete'
    }), showRemoteLinkIcon), /*#__PURE__*/_react2.default.createElement(_eui.EuiContextMenuItem, {
      key: "reset",
      icon: "refresh",
      disabled: !(permissions !== null && permissions !== void 0 && permissions.hasAllWriteRequested) || hasUndefinedRemoteKibanaUrl,
      onClick: handleReset,
      toolTipContent: hasUndefinedRemoteKibanaUrl ? NOT_AVAILABLE_FOR_UNDEFINED_REMOTE_KIBANA_URL : '',
      "data-test-subj": "sloActionsReset",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 300,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.slo.item.actions.reset', {
      defaultMessage: 'Reset'
    }), showRemoteLinkIcon)].concat(!isDashboardContext && !!setDashboardAttachmentReady ? /*#__PURE__*/_react2.default.createElement(_eui.EuiContextMenuItem, {
      icon: "dashboardApp",
      key: "addToDashboard",
      onClick: handleAddToDashboard,
      "data-test-subj": "sloActionsAddToDashboard",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 315,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.slo.item.actions.addToDashboard', {
      defaultMessage: 'Add to Dashboard'
    })) : []),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 7
    }
  }));
}
const NOT_AVAILABLE_FOR_REMOTE = _i18n.i18n.translate('xpack.slo.item.actions.notAvailable', {
  defaultMessage: 'This action is not available for remote SLOs'
});
const NOT_AVAILABLE_FOR_UNDEFINED_REMOTE_KIBANA_URL = _i18n.i18n.translate('xpack.slo.item.actions.remoteKibanaUrlUndefined', {
  defaultMessage: 'This action is not available for remote SLOs with undefined kibanaUrl'
});