"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloManagementPage = SloManagementPage;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _paths = require("../../../common/locators/paths");
var _header_menu = require("../../components/header_menu/header_menu");
var _use_fetch_slo_definitions = require("../../hooks/use_fetch_slo_definitions");
var _use_kibana = require("../../hooks/use_kibana");
var _use_license = require("../../hooks/use_license");
var _use_permissions = require("../../hooks/use_permissions");
var _use_plugin_context = require("../../hooks/use_plugin_context");
var _slo_management_outdated_filter_callout = require("./components/slo_management_outdated_filter_callout");
var _slo_management_table = require("./components/slo_management_table");
var _action_modal = require("../../context/action_modal");
var _bulk_operation = require("./context/bulk_operation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_management/slo_management_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SloManagementPage() {
  const {
    http: {
      basePath
    },
    serverless,
    application: {
      navigateToUrl
    }
  } = (0, _use_kibana.useKibana)().services;
  const {
    ObservabilityPageTemplate
  } = (0, _use_plugin_context.usePluginContext)();
  const {
    data: permissions
  } = (0, _use_permissions.usePermissions)();
  const {
    hasAtLeast
  } = (0, _use_license.useLicense)();
  const {
    isLoading,
    isError,
    data: {
      total
    } = {
      total: 0
    }
  } = (0, _use_fetch_slo_definitions.useFetchSloDefinitions)({
    perPage: 0
  });
  (0, _react.useEffect)(() => {
    if (hasAtLeast('platinum') === false || (permissions === null || permissions === void 0 ? void 0 : permissions.hasAllReadRequested) === false || !isLoading && total === 0 || isError) {
      navigateToUrl(basePath.prepend(_paths.paths.slosWelcome));
    }
  }, [basePath, hasAtLeast, isError, isLoading, navigateToUrl, total, permissions]);
  (0, _public.useBreadcrumbs)([{
    href: basePath.prepend(_paths.paths.slos),
    text: _i18n.i18n.translate('xpack.slo.breadcrumbs.sloTitle', {
      defaultMessage: 'SLOs'
    }),
    deepLinkId: 'slo'
  }, {
    text: _i18n.i18n.translate('xpack.slo.breadcrumbs.managementTitle', {
      defaultMessage: 'Management'
    })
  }], {
    serverless
  });
  return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    "data-test-subj": "managementPage",
    pageHeader: {
      pageTitle: _i18n.i18n.translate('xpack.slo.managementPage.pageTitle', {
        defaultMessage: 'SLO Management'
      })
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_header_menu.HeaderMenu, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_bulk_operation.BulkOperationProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_action_modal.ActionModalProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_slo_management_outdated_filter_callout.SloOutdatedFilterCallout, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_slo_management_table.SloManagementTable, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 13
    }
  })))));
}