"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloOutdatedFilterCallout = SloOutdatedFilterCallout;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_url_search_state = require("../hooks/use_url_search_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_management/components/slo_management_outdated_filter_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function SloOutdatedFilterCallout() {
  const {
    state,
    onStateChange
  } = (0, _use_url_search_state.useUrlSearchState)();
  if (!state.includeOutdatedOnly) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "primary",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 20,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 21,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "info",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 9
    }
  }), ' ', _i18n.i18n.translate('xpack.slo.outdatedSloFilterCallout.title', {
    defaultMessage: "You're currently viewing only outdated SLOs. You can reset them from the action menu to bring them up to date."
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "outdated-filter-help-callout",
    onClick: () => {
      onStateChange({
        ...state,
        includeOutdatedOnly: false
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.slo.outdatedSloFilterCallout.action', {
    defaultMessage: 'Remove filter'
  }))));
}