"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformCreateSLOFormToCreateSLOInput = transformCreateSLOFormToCreateSLOInput;
exports.transformPartialSLOStateToFormState = transformPartialSLOStateToFormState;
exports.transformSloResponseToCreateSloForm = transformSloResponseToCreateSloForm;
exports.transformValuesToUpdateSLOInput = transformValuesToUpdateSLOInput;
var _std = require("@kbn/std");
var _lodash = require("lodash");
var _duration = require("../../../utils/slo/duration");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function transformSloResponseToCreateSloForm(values) {
  var _values$settings$prev, _values$settings, _values$settings2, _values$settings3, _values$settings$sync, _values$settings4, _values$artifacts;
  if (!values) return undefined;
  return {
    name: values.name,
    description: values.description,
    indicator: values.indicator,
    budgetingMethod: values.budgetingMethod,
    timeWindow: {
      duration: values.timeWindow.duration,
      type: values.timeWindow.type
    },
    objective: {
      target: values.objective.target * 100,
      ...(values.budgetingMethod === 'timeslices' && values.objective.timesliceTarget && {
        timesliceTarget: values.objective.timesliceTarget * 100
      }),
      ...(values.budgetingMethod === 'timeslices' && values.objective.timesliceWindow && {
        timesliceWindow: String((0, _duration.toDuration)(values.objective.timesliceWindow).value)
      })
    },
    groupBy: [values.groupBy].flat(),
    tags: values.tags,
    settings: {
      preventInitialBackfill: (_values$settings$prev = (_values$settings = values.settings) === null || _values$settings === void 0 ? void 0 : _values$settings.preventInitialBackfill) !== null && _values$settings$prev !== void 0 ? _values$settings$prev : false,
      syncDelay: (_values$settings2 = values.settings) !== null && _values$settings2 !== void 0 && _values$settings2.syncDelay ? (0, _duration.toMinutes)((0, _duration.toDuration)(values.settings.syncDelay)) : _constants.SETTINGS_DEFAULT_VALUES.syncDelay,
      frequency: (_values$settings3 = values.settings) !== null && _values$settings3 !== void 0 && _values$settings3.frequency ? (0, _duration.toMinutes)((0, _duration.toDuration)(values.settings.frequency)) : _constants.SETTINGS_DEFAULT_VALUES.frequency,
      syncField: (_values$settings$sync = (_values$settings4 = values.settings) === null || _values$settings4 === void 0 ? void 0 : _values$settings4.syncField) !== null && _values$settings$sync !== void 0 ? _values$settings$sync : null
    },
    artifacts: {
      dashboards: ((_values$artifacts = values.artifacts) === null || _values$artifacts === void 0 ? void 0 : _values$artifacts.dashboards) || []
    }
  };
}
function transformCreateSLOFormToCreateSLOInput(values) {
  var _values$settings$sync2, _values$settings$freq, _values$artifacts2;
  return {
    name: values.name,
    description: values.description,
    indicator: values.indicator,
    budgetingMethod: values.budgetingMethod,
    timeWindow: {
      duration: values.timeWindow.duration,
      type: values.timeWindow.type
    },
    objective: {
      target: values.objective.target / 100,
      ...(values.budgetingMethod === 'timeslices' && values.objective.timesliceTarget && {
        timesliceTarget: values.objective.timesliceTarget / 100
      }),
      ...(values.budgetingMethod === 'timeslices' && values.objective.timesliceWindow && {
        timesliceWindow: `${values.objective.timesliceWindow}m`
      })
    },
    tags: values.tags,
    groupBy: [values.groupBy].flat(),
    settings: {
      preventInitialBackfill: values.settings.preventInitialBackfill,
      syncDelay: `${(_values$settings$sync2 = values.settings.syncDelay) !== null && _values$settings$sync2 !== void 0 ? _values$settings$sync2 : _constants.SETTINGS_DEFAULT_VALUES.syncDelay}m`,
      frequency: `${(_values$settings$freq = values.settings.frequency) !== null && _values$settings$freq !== void 0 ? _values$settings$freq : _constants.SETTINGS_DEFAULT_VALUES.frequency}m`,
      syncField: values.settings.syncField
    },
    artifacts: {
      dashboards: ((_values$artifacts2 = values.artifacts) === null || _values$artifacts2 === void 0 ? void 0 : _values$artifacts2.dashboards) || []
    }
  };
}
function transformValuesToUpdateSLOInput(values) {
  var _values$settings$sync3, _values$settings$freq2, _values$artifacts3;
  return {
    name: values.name,
    description: values.description,
    indicator: values.indicator,
    budgetingMethod: values.budgetingMethod,
    timeWindow: {
      duration: values.timeWindow.duration,
      type: values.timeWindow.type
    },
    objective: {
      target: values.objective.target / 100,
      ...(values.budgetingMethod === 'timeslices' && values.objective.timesliceTarget && {
        timesliceTarget: values.objective.timesliceTarget / 100
      }),
      ...(values.budgetingMethod === 'timeslices' && values.objective.timesliceWindow && {
        timesliceWindow: `${values.objective.timesliceWindow}m`
      })
    },
    tags: values.tags,
    groupBy: [values.groupBy].flat(),
    settings: {
      preventInitialBackfill: values.settings.preventInitialBackfill,
      syncDelay: `${(_values$settings$sync3 = values.settings.syncDelay) !== null && _values$settings$sync3 !== void 0 ? _values$settings$sync3 : _constants.SETTINGS_DEFAULT_VALUES.syncDelay}m`,
      frequency: `${(_values$settings$freq2 = values.settings.frequency) !== null && _values$settings$freq2 !== void 0 ? _values$settings$freq2 : _constants.SETTINGS_DEFAULT_VALUES.frequency}m`,
      syncField: values.settings.syncField
    },
    artifacts: {
      dashboards: ((_values$artifacts3 = values.artifacts) === null || _values$artifacts3 === void 0 ? void 0 : _values$artifacts3.dashboards) || []
    }
  };
}
function transformPartialIndicatorState(indicator) {
  var _indicator$params, _indicator$params2, _indicator$params3, _indicator$params4, _indicator$params5, _indicator$params6, _indicator$params7;
  if (indicator === undefined || indicator.type === undefined) return undefined;
  const indicatorType = indicator.type;
  switch (indicatorType) {
    case 'sli.apm.transactionDuration':
      return {
        type: 'sli.apm.transactionDuration',
        params: Object.assign({}, _constants.APM_LATENCY_DEFAULT_VALUES.params, (_indicator$params = indicator.params) !== null && _indicator$params !== void 0 ? _indicator$params : {})
      };
    case 'sli.apm.transactionErrorRate':
      return {
        type: 'sli.apm.transactionErrorRate',
        params: Object.assign({}, _constants.APM_AVAILABILITY_DEFAULT_VALUES.params, (_indicator$params2 = indicator.params) !== null && _indicator$params2 !== void 0 ? _indicator$params2 : {})
      };
    case 'sli.synthetics.availability':
      return {
        type: 'sli.synthetics.availability',
        params: Object.assign({}, _constants.SYNTHETICS_AVAILABILITY_DEFAULT_VALUES.params, (_indicator$params3 = indicator.params) !== null && _indicator$params3 !== void 0 ? _indicator$params3 : {})
      };
    case 'sli.histogram.custom':
      return {
        type: 'sli.histogram.custom',
        params: Object.assign({}, _constants.HISTOGRAM_DEFAULT_VALUES.params, (_indicator$params4 = indicator.params) !== null && _indicator$params4 !== void 0 ? _indicator$params4 : {})
      };
    case 'sli.kql.custom':
      return {
        type: 'sli.kql.custom',
        params: Object.assign({}, _constants.CUSTOM_KQL_DEFAULT_VALUES.params, (_indicator$params5 = indicator.params) !== null && _indicator$params5 !== void 0 ? _indicator$params5 : {})
      };
    case 'sli.metric.custom':
      return {
        type: 'sli.metric.custom',
        params: Object.assign({}, _constants.CUSTOM_METRIC_DEFAULT_VALUES.params, (_indicator$params6 = indicator.params) !== null && _indicator$params6 !== void 0 ? _indicator$params6 : {})
      };
    case 'sli.metric.timeslice':
      return {
        type: 'sli.metric.timeslice',
        params: Object.assign({}, _constants.TIMESLICE_METRIC_DEFAULT_VALUES.params, (_indicator$params7 = indicator.params) !== null && _indicator$params7 !== void 0 ? _indicator$params7 : {})
      };
    default:
      (0, _std.assertNever)(indicatorType);
  }
}
function transformPartialSLOStateToFormState(values) {
  var _values$timeWindow, _values$timeWindow2;
  let state;
  const indicator = transformPartialIndicatorState(values.indicator);
  switch (indicator === null || indicator === void 0 ? void 0 : indicator.type) {
    case 'sli.synthetics.availability':
      state = (0, _lodash.cloneDeep)(_constants.SLO_EDIT_FORM_DEFAULT_VALUES_SYNTHETICS_AVAILABILITY);
      break;
    default:
      state = (0, _lodash.cloneDeep)(_constants.SLO_EDIT_FORM_DEFAULT_VALUES);
  }
  if (indicator !== undefined) {
    state.indicator = indicator;
  }
  if (values.name) {
    state.name = values.name;
  }
  if (values.description) {
    state.description = values.description;
  }
  if (values.tags) {
    state.tags = [values.tags].flat().filter(tag => !!tag);
  }
  if (values.objective) {
    if (values.objective.target) {
      state.objective = {
        target: values.objective.target * 100
      };
      if (values.objective.timesliceTarget && values.objective.timesliceWindow) {
        state.objective.timesliceTarget = values.objective.timesliceTarget * 100;
        state.objective.timesliceWindow = String((0, _duration.toDuration)(values.objective.timesliceWindow).value);
      }
    }
  }
  if (values.budgetingMethod) {
    state.budgetingMethod = values.budgetingMethod;
  }
  if (values.groupBy) {
    state.groupBy = [values.groupBy].flat().filter(group => !!group);
  }
  if ((_values$timeWindow = values.timeWindow) !== null && _values$timeWindow !== void 0 && _values$timeWindow.duration && (_values$timeWindow2 = values.timeWindow) !== null && _values$timeWindow2 !== void 0 && _values$timeWindow2.type) {
    state.timeWindow = {
      duration: values.timeWindow.duration,
      type: values.timeWindow.type
    };
  }
  if (!!values.settings) {
    if (values.settings.preventInitialBackfill) {
      state.settings.preventInitialBackfill = values.settings.preventInitialBackfill;
    }
    if (values.settings.syncDelay) {
      state.settings.syncDelay = (0, _duration.toMinutes)((0, _duration.toDuration)(values.settings.syncDelay));
    }
    if (values.settings.frequency) {
      state.settings.frequency = (0, _duration.toMinutes)((0, _duration.toDuration)(values.settings.frequency));
    }
    if (values.settings.syncField) {
      state.settings.syncField = values.settings.syncField;
    }
  }
  return state;
}