"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimestampFieldSelector = TimestampFieldSelector;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _create_options = require("../../helpers/create_options");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_edit/components/common/timestamp_field_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const placeholder = _i18n.i18n.translate('xpack.slo.sloEdit.timestampField.placeholder', {
  defaultMessage: 'Select a timestamp field'
});
function TimestampFieldSelector({
  fields,
  isDisabled,
  isLoading
}) {
  const {
    control,
    getFieldState
  } = (0, _reactHookForm.useFormContext)();
  const [options, setOptions] = (0, _react.useState)((0, _create_options.createOptionsFromFields)(fields));
  (0, _react.useEffect)(() => {
    setOptions((0, _create_options.createOptionsFromFields)(fields));
  }, [fields]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.slo.sloEdit.timestampField.label', {
      defaultMessage: 'Timestamp field'
    }),
    isInvalid: getFieldState('indicator.params.timestampField').invalid,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: 'indicator.params.timestampField',
    control: control,
    rules: {
      required: !isDisabled
    },
    render: ({
      field,
      fieldState
    }) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({}, field, {
        compressed: true,
        async: true,
        placeholder: placeholder,
        "aria-label": placeholder,
        isClearable: true,
        isDisabled: isLoading || isDisabled,
        isInvalid: fieldState.invalid,
        isLoading: isLoading,
        onChange: selected => {
          if (selected.length) {
            return field.onChange(selected[0].value);
          }
          field.onChange('');
        },
        singleSelection: {
          asPlainText: true
        },
        options: options,
        onSearchChange: searchValue => {
          setOptions((0, _create_options.createOptionsFromFields)(fields, ({
            value
          }) => value.includes(searchValue)));
        },
        selectedOptions: !!fields && !!field.value ? [{
          value: field.value,
          label: field.value
        }] : [],
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 49,
          columnNumber: 13
        }
      }));
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }));
}