"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchSloGroupings = useFetchSloGroupings;
var _sloSchema = require("@kbn/slo-schema");
var _reactQuery = require("@kbn/react-query");
var _query_key_factory = require("../../../hooks/query_key_factory");
var _use_plugin_context = require("../../../hooks/use_plugin_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchSloGroupings({
  sloId,
  groupingKey,
  instanceId,
  afterKey,
  search,
  remoteName
}) {
  const {
    sloClient
  } = (0, _use_plugin_context.usePluginContext)();
  const {
    isLoading,
    isError,
    data
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_key_factory.sloKeys.groupings({
      sloId,
      groupingKey,
      instanceId,
      afterKey,
      search,
      remoteName
    }),
    queryFn: async ({
      signal
    }) => {
      try {
        return await sloClient.fetch(`GET /internal/observability/slos/{id}/_groupings`, {
          params: {
            path: {
              id: sloId
            },
            query: {
              search,
              instanceId,
              groupingKey,
              afterKey,
              excludeStale: true,
              remoteName
            }
          },
          signal
        });
      } catch (error) {
        throw new Error(`Something went wrong. Error: ${error}`);
      }
    },
    enabled: Boolean(!!sloId && !!groupingKey && instanceId !== _sloSchema.ALL_VALUE),
    staleTime: 60 * 1000,
    retry: false,
    refetchOnWindowFocus: false
  });
  return {
    isLoading,
    isError,
    data
  };
}