"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorBudgetChartPanel = ErrorBudgetChartPanel;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/presentation-util-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../embeddable/slo/error_budget/constants");
var _use_kibana = require("../../../hooks/use_kibana");
var _error_budget_chart = require("./error_budget_chart");
var _error_budget_header = require("./error_budget_header");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_details/components/error_budget_chart_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SavedObjectSaveModalDashboard = (0, _public.withSuspense)(_public.LazySavedObjectSaveModalDashboard);
function ErrorBudgetChartPanel({
  data,
  isLoading,
  slo,
  hideMetadata = false,
  onBrushed
}) {
  const [isMouseOver, setIsMouseOver] = (0, _react.useState)(false);
  const [isDashboardAttachmentReady, setDashboardAttachmentReady] = (0, _react.useState)(false);
  const {
    embeddable
  } = (0, _use_kibana.useKibana)().services;
  const handleAttachToDashboardSave = (0, _react.useCallback)(async ({
    dashboardId,
    newTitle,
    newDescription
  }) => {
    const stateTransfer = embeddable.getStateTransfer();
    const embeddableInput = {
      title: newTitle,
      description: newDescription,
      sloId: slo.id,
      sloInstanceId: slo.instanceId
    };
    const state = {
      serializedState: {
        rawState: embeddableInput
      },
      type: _constants.SLO_ERROR_BUDGET_ID
    };
    const path = dashboardId === 'new' ? '#/create' : `#/view/${dashboardId}`;
    stateTransfer.navigateToWithEmbeddablePackage('dashboards', {
      state,
      path
    });
  }, [embeddable, slo.id, slo.instanceId]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    color: "transparent",
    hasBorder: true,
    "data-test-subj": "errorBudgetChartPanel",
    onMouseOver: () => {
      if (!isMouseOver) {
        setIsMouseOver(true);
      }
    },
    onMouseLeave: () => {
      if (isMouseOver) {
        setIsMouseOver(false);
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_error_budget_header.ErrorBudgetHeader, {
    slo: slo,
    isMouseOver: isMouseOver,
    setDashboardAttachmentReady: setDashboardAttachmentReady,
    hideMetadata: hideMetadata,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_error_budget_chart.ErrorBudgetChart, {
    slo: slo,
    data: data,
    isLoading: isLoading,
    hideMetadata: hideMetadata,
    onBrushed: onBrushed,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  }))), isDashboardAttachmentReady ? /*#__PURE__*/_react.default.createElement(SavedObjectSaveModalDashboard, {
    objectType: _i18n.i18n.translate('xpack.slo.errorBudgetBurnDown.actions.attachToDashboard.objectTypeLabel', {
      defaultMessage: 'SLO Error Budget burn down'
    }),
    documentInfo: {
      title: _i18n.i18n.translate('xpack.slo.errorBudgetBurnDown.actions.attachToDashboard.attachmentTitle', {
        defaultMessage: 'SLO Error Budget burn down'
      })
    },
    canSaveByReference: false,
    onClose: () => {
      setDashboardAttachmentReady(false);
    },
    onSave: handleAttachToDashboardSave,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 9
    }
  }) : null);
}