"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openConfiguration = openConfiguration;
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _reactQuery = require("@kbn/react-query");
var _react = _interopRequireDefault(require("react"));
var _plugin_context = require("../../../context/plugin_context");
var _configuration = require("./configuration");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/slo/public/embeddable/slo/burn_rate/open_configuration.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
async function openConfiguration(coreStart, pluginsStart, sloClient, initialState) {
  const {
    overlays
  } = coreStart;
  const queryClient = new _reactQuery.QueryClient();
  return new Promise(async (resolve, reject) => {
    try {
      const flyoutSession = overlays.openFlyout((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
        services: {
          ...coreStart,
          ...pluginsStart
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 31,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_plugin_context.PluginContext.Provider, {
        value: {
          observabilityRuleTypeRegistry: pluginsStart.observability.observabilityRuleTypeRegistry,
          ObservabilityPageTemplate: pluginsStart.observabilityShared.navigation.PageTemplate,
          sloClient
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 37,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
        client: queryClient,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 45,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_configuration.Configuration, {
        onCreate: update => {
          flyoutSession.close();
          resolve(update);
        },
        onCancel: () => {
          flyoutSession.close();
          reject();
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 46,
          columnNumber: 17
        }
      })))), coreStart));
    } catch (error) {
      reject(error);
    }
  });
}