"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloPurgeConfirmationModal = SloPurgeConfirmationModal;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/slo/public/components/slo/purge_confirmation_modal/purge_confirmation_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function SloPurgeConfirmationModal({
  modalTitle,
  purgePolicyHelpText,
  onCancel,
  onConfirm
}) {
  const [purgeDate, setPurgeDate] = _react.default.useState((0, _moment.default)());
  const [purgeType, setPurgeType] = _react.default.useState('fixed_age');
  const [forcePurge, setForgePurge] = _react.default.useState(false);
  const [age, setAge] = _react.default.useState('7d');
  const basicCheckboxId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'basicCheckbox'
  });
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const purgeTimeLabel = _i18n.i18n.translate('xpack.slo.purgeConfirmationModal.purgeDataDescription', {
    defaultMessage: 'Purge data older than'
  });
  const onClickConfirm = () => {
    onConfirm({
      purgeDate,
      purgeType,
      forcePurge,
      age
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: modalTitle,
    titleProps: {
      id: modalTitleId
    },
    buttonColor: "danger",
    "data-test-subj": "sloPurgeConfirmationModal",
    cancelButtonText: _i18n.i18n.translate('xpack.slo.purgeConfirmationModal.cancelButtonLabel', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.slo.purgeConfirmationModal.confirmButtonLabel', {
      defaultMessage: 'Purge'
    }),
    onCancel: onCancel,
    onConfirm: onClickConfirm,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  }, purgePolicyHelpText, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.slo.purgeConfirmationModal.purgeTypeLabel', {
      defaultMessage: 'Choose basis by which to purge data'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    "data-test-subj": "sloPurgeConfirmationModalPurgeType",
    options: [{
      id: 'fixed_age',
      label: _i18n.i18n.translate('xpack.slo.purgeConfirmationModal.fixedAgeLabel', {
        defaultMessage: 'Age of data'
      })
    }, {
      id: 'fixed_time',
      label: _i18n.i18n.translate('xpack.slo.purgeConfirmationModal.fixedDateTimeLabel', {
        defaultMessage: 'Specific date and time'
      })
    }],
    idSelected: purgeType,
    onChange: val => {
      setPurgeType(val);
    },
    name: "purgeType",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  })), purgeType === 'fixed_age' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: purgeTimeLabel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    "data-test-subj": "sloPurgeConfirmationModalPurgeAge",
    options: [{
      id: '7d',
      label: _i18n.i18n.translate('xpack.slo.purgeConfirmationModal.last7DaysLabel', {
        defaultMessage: '7 days'
      })
    }, {
      id: '30d',
      label: _i18n.i18n.translate('xpack.slo.purgeConfirmationModal.last30DaysLabel', {
        defaultMessage: '30 days'
      })
    }, {
      id: '90d',
      label: _i18n.i18n.translate('xpack.slo.purgeConfirmationModal.last90DaysLabel', {
        defaultMessage: '90 days'
      })
    }],
    idSelected: age,
    onChange: setAge,
    name: "purgeAge",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 11
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: purgeTimeLabel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
    showTimeSelect: true,
    selected: purgeDate,
    onChange: setPurgeDate,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: basicCheckboxId,
    checked: forcePurge,
    onChange: e => {
      setForgePurge(e.target.checked);
    },
    label: _i18n.i18n.translate('xpack.slo.purgeConfirmationModal.forcePurge', {
      defaultMessage: 'Ignore purge policy restrictions'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  })), forcePurge && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    size: "s",
    title: _i18n.i18n.translate('xpack.slo.purgeConfirmationModal.forceWarning', {
      defaultMessage: 'Ignoring purge policy restrictions may delete data that is used to calculate SLOs'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 11
    }
  })));
}