"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLensDefinitionInterval = getLensDefinitionInterval;
var _sloSchema = require("@kbn/slo-schema");
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// For a timeslice SLO
// When the date range is lower than 24 hours, we force the interval to be the timeslice window
// Greater than 24 hours, the 'auto' interval will be fine
function getLensDefinitionInterval(dataTimeRange, slo) {
  var _slo$objective;
  const dataTimeRangeDuration = (0, _moment.default)(dataTimeRange.to).diff((0, _moment.default)(dataTimeRange.from), 'ms');
  const interval = _sloSchema.timeslicesBudgetingMethodSchema.is(slo.budgetingMethod) && dataTimeRangeDuration <= 86400000 && (_slo$objective = slo.objective) !== null && _slo$objective !== void 0 && _slo$objective.timesliceWindow ? slo.objective.timesliceWindow : 'auto';
  return interval;
}