"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloBulkDeleteConfirmationModal = SloBulkDeleteConfirmationModal;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_bulk_delete_slo = require("../../../pages/slo_management/hooks/use_bulk_delete_slo");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/slo/public/components/slo/bulk_delete_confirmation_modal/bulk_delete_confirmation_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function SloBulkDeleteConfirmationModal({
  items,
  onCancel,
  onConfirm
}) {
  const {
    mutate: bulkDelete
  } = (0, _use_bulk_delete_slo.useBulkDeleteSlo)({
    onConfirm
  });
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    titleProps: {
      id: modalTitleId
    },
    buttonColor: "danger",
    "data-test-subj": "sloBulkDeleteConfirmationModal",
    title: _i18n.i18n.translate('xpack.slo.bulkDeleteConfirmationModal.title', {
      defaultMessage: 'Delete {count} SLOs',
      values: {
        count: items.length
      }
    }),
    cancelButtonText: _i18n.i18n.translate('xpack.slo.bulkDeleteConfirmationModal.cancelButtonLabel', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.slo.bulkDeleteConfirmationModal.confirmButtonLabel', {
      defaultMessage: 'Delete'
    }),
    onCancel: onCancel,
    onConfirm: () => {
      bulkDelete({
        items: items.map(item => ({
          id: item.id
        }))
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.slo.bulkDeleteConfirmationModal.descriptionText', {
    defaultMessage: 'This will delete the SLOs, their instances and all their data.'
  }));
}