"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutoRefreshButton = AutoRefreshButton;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/slo/public/components/slo/auto_refresh_button/auto_refresh_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function AutoRefreshButton({
  disabled,
  isAutoRefreshing,
  onClick
}) {
  return isAutoRefreshing ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "autoRefreshButton",
    disabled: disabled,
    iconSide: "left",
    iconType: "pause",
    onClick: onClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 19,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.slo.slosPage.stopRefreshingButtonLabel', {
    defaultMessage: 'Stop refreshing'
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "autoRefreshButton",
    disabled: disabled,
    iconSide: "left",
    iconType: "refresh",
    onClick: onClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.slo.slosPage.autoRefreshButtonLabel', {
    defaultMessage: 'Auto-refresh'
  }));
}