"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = AlertDetailsAppSection;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_kibana = require("../../hooks/use_kibana");
var _use_fetch_slo_details = require("../../hooks/use_fetch_slo_details");
var _custom_panels = require("./components/custom_panels/custom_panels");
var _error_rate_panel = require("./components/error_rate/error_rate_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/slo/public/components/alert_details/alert_details_app_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// eslint-disable-next-line import/no-default-export
function AlertDetailsAppSection({
  alert,
  rule,
  setSources
}) {
  const {
    services: {
      http: {
        basePath
      }
    }
  } = (0, _use_kibana.useKibana)();
  const sloId = alert.fields['kibana.alert.rule.parameters'].sloId;
  const instanceId = alert.fields['kibana.alert.instance.id'];
  const {
    isLoading,
    data: slo
  } = (0, _use_fetch_slo_details.useFetchSloDetails)({
    sloId,
    instanceId
  });
  const alertLink = alert.link;
  (0, _react.useEffect)(() => {
    var _slo$name;
    const fields = [{
      label: _i18n.i18n.translate('xpack.slo.burnRateRule.alertDetailsAppSection.summaryField.slo', {
        defaultMessage: 'SLO'
      }),
      value: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "sloLink",
        href: basePath.prepend(alertLink),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 43,
          columnNumber: 11
        }
      }, (_slo$name = slo === null || slo === void 0 ? void 0 : slo.name) !== null && _slo$name !== void 0 ? _slo$name : '-')
    }];
    setSources(fields);
  }, [alertLink, rule, setSources, basePath, slo, instanceId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    "data-test-subj": "overviewSection",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_error_rate_panel.ErrorRatePanel, {
    alert: alert,
    slo: slo,
    isLoading: isLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_custom_panels.CustomAlertDetailsPanel, {
    alert: alert,
    slo: slo,
    rule: rule,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }));
}
module.exports = exports.default;