"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeTypeSection = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _time_utils = require("../../../lib/time_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/share/public/components/tabs/link/time_type_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BoldText = ({
  children
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const boldText = (0, _react2.css)`
    font-weight: ${euiTheme.font.weight.bold};
  `;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    css: boldText,
    component: "span",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }, children);
};
const AbsoluteTimeText = ({
  date
}) => {
  const absoluteDate = (0, _time_utils.convertRelativeTimeStringToAbsoluteTimeDate)(date);
  return /*#__PURE__*/_react.default.createElement(BoldText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
    value: absoluteDate,
    year: "numeric",
    month: "long",
    day: "2-digit",
    hour: "numeric",
    minute: "numeric",
    hour12: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }));
};
const RelativeTimeText = ({
  value,
  unit,
  roundingUnit
}) => {
  // Handle plain "now" case - FormattedRelativeTime can't render it properly
  if (value === 0 && unit === 'second' && !roundingUnit) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "share.link.timeRange.now",
      defaultMessage: "<bold>now</bold>",
      values: {
        bold: chunks => /*#__PURE__*/_react.default.createElement(BoldText, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 69,
            columnNumber: 29
          }
        }, chunks)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(BoldText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelativeTime, {
    value: value
    // @ts-expect-error - RelativeTimeFormatSingularUnit expected here is not exported so a cast from string is not possible
    ,
    unit: unit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }), roundingUnit && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "share.link.timeRange.relativeTimeInfoText.roundingUnit",
    defaultMessage: " rounded to the {roundingUnit}",
    values: {
      roundingUnit
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }));
};
const getTimeRangeText = timeRange => {
  const fromIsRelative = timeRange.from.includes('now');
  const toIsRelative = timeRange.to.includes('now');
  const from = (0, _time_utils.getRelativeTimeValueAndUnitFromTimeString)(timeRange.from);
  const to = (0, _time_utils.getRelativeTimeValueAndUnitFromTimeString)(timeRange.to);
  const fromValue = fromIsRelative ? /*#__PURE__*/_react.default.createElement(RelativeTimeText, {
    value: from === null || from === void 0 ? void 0 : from.value,
    unit: from === null || from === void 0 ? void 0 : from.unit,
    roundingUnit: from === null || from === void 0 ? void 0 : from.roundingUnit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(AbsoluteTimeText, {
    date: timeRange.from,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 5
    }
  });
  const toValue = toIsRelative ? /*#__PURE__*/_react.default.createElement(RelativeTimeText, {
    value: to === null || to === void 0 ? void 0 : to.value,
    unit: to === null || to === void 0 ? void 0 : to.unit,
    roundingUnit: to === null || to === void 0 ? void 0 : to.roundingUnit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(AbsoluteTimeText, {
    date: timeRange.to,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "share.link.timeRange.relativeTimeInfoText",
    defaultMessage: "The users will see all data from {from} to {to}, based on when they view it.",
    values: {
      from: fromValue,
      to: toValue
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 5
    }
  });
};
const TimeTypeSection = ({
  timeRange,
  onTimeTypeChange,
  isAbsoluteTimeByDefault
}) => {
  const [isAbsoluteTime, setIsAbsoluteTime] = (0, _react.useState)(isAbsoluteTimeByDefault);
  const handleTimeTypeChange = e => {
    const newIsAbsolute = e.target.checked;
    setIsAbsoluteTime(newIsAbsolute);
    onTimeTypeChange === null || onTimeTypeChange === void 0 ? void 0 : onTimeTypeChange(newIsAbsolute);
  };
  if (!timeRange) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !isAbsoluteTimeByDefault && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('share.link.timeRange.switchLabel', {
      defaultMessage: 'Use absolute time range'
    }),
    checked: isAbsoluteTime,
    onChange: handleTimeTypeChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 7
    }
  }, isAbsoluteTime ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "absoluteTimeInfoText",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "share.link.timeRange.absoluteTimeInfoText",
    defaultMessage: "The users will see all data from {from} to {to}.",
    values: {
      from: /*#__PURE__*/_react.default.createElement(AbsoluteTimeText, {
        date: timeRange === null || timeRange === void 0 ? void 0 : timeRange.from,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 174,
          columnNumber: 23
        }
      }),
      to: /*#__PURE__*/_react.default.createElement(AbsoluteTimeText, {
        date: timeRange === null || timeRange === void 0 ? void 0 : timeRange.to,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 175,
          columnNumber: 21
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 13
    }
  })) : getTimeRangeText(timeRange)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 7
    }
  }), isAbsoluteTimeByDefault && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    title: _i18n.i18n.translate('share.link.timeRange.relativeTimeCallout', {
      defaultMessage: 'To use a relative time range, select it in the time picker first.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 9
    }
  }));
};
exports.TimeTypeSection = TimeTypeSection;