"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TTYSearchBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _stripAnsi = _interopRequireDefault(require("strip-ansi"));
var _session_view_search_bar = require("../session_view_search_bar");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/session_view/public/components/tty_search_bar/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const STRIP_NEWLINES_REGEX = /^(\r\n|\r|\n|\n\r)/;
const TTYSearchBar = ({
  lines,
  seekToLine,
  xTermSearchFn,
  setIsPlaying,
  searchQuery,
  setSearchQuery
}) => {
  const [currentMatch, setCurrentMatch] = (0, _react.useState)(null);
  const jumpToMatch = (0, _react.useCallback)(match => {
    if (match) {
      setIsPlaying(false);
      const goToLine = lines.indexOf(match.line);
      seekToLine(goToLine);
    }
    const timeout = setTimeout(() => {
      return xTermSearchFn(searchQuery, (match === null || match === void 0 ? void 0 : match.index) || 0);
    }, 100);
    return () => {
      clearTimeout(timeout);
    };
  }, [setIsPlaying, lines, seekToLine, xTermSearchFn, searchQuery]);
  const searchResults = (0, _react.useMemo)(() => {
    const matches = [];
    if (searchQuery) {
      lines.reduce((previous, current) => {
        if (current.value) {
          // check for cursor movement at the start of the line
          const cursorMovement = current.value.match(/^\x1b\[\d+;(\d+)(H|d)/);
          const regex = new RegExp(searchQuery.replace(/[.*+?^${}()|[\]\\]/g, '\\$&'), 'ig');
          const lineMatches = (0, _stripAnsi.default)(current.value).replace(STRIP_NEWLINES_REGEX, '').matchAll(regex);
          if (lineMatches) {
            for (const match of lineMatches) {
              let matchOffset = 0;
              if (cursorMovement) {
                // the column position 1 based e.g \x1b[39;5H means row 39 column 5
                matchOffset = parseInt(cursorMovement[1], 10) - 3;
              }
              previous.push({
                line: current,
                match: match[0],
                index: matchOffset + (match.index || 0)
              });
            }
          }
        }
        return previous;
      }, matches);
    }
    if (matches.length > 0) {
      const firstMatch = matches[0];
      setCurrentMatch(firstMatch);
      jumpToMatch(firstMatch);
    } else {
      setCurrentMatch(null);
      xTermSearchFn('', 0);
    }
    return matches;
  }, [searchQuery, lines, jumpToMatch, xTermSearchFn]);
  const onSearch = (0, _react.useCallback)(query => {
    setIsPlaying(false);
    setSearchQuery(query);
    setCurrentMatch(null);
  }, [setIsPlaying, setSearchQuery]);
  const onSetCurrentMatch = (0, _react.useCallback)(index => {
    const match = searchResults[index];
    if (match && currentMatch !== match) {
      setCurrentMatch(match);
      jumpToMatch(match);
    }
  }, [jumpToMatch, currentMatch, searchResults]);
  return /*#__PURE__*/_react.default.createElement(_session_view_search_bar.SessionViewSearchBar, {
    searchQuery: searchQuery,
    setSearchQuery: onSearch,
    totalMatches: searchResults.length,
    onNext: onSetCurrentMatch,
    onPrevious: onSetCurrentMatch,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 5
    }
  });
};
exports.TTYSearchBar = TTYSearchBar;