"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessTreeLoadMoreButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _styles = require("./styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/session_view/public/components/process_tree_load_more_button/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ProcessTreeLoadMoreButton = ({
  onClick,
  text,
  isFetching,
  eventsRemaining,
  forward
}) => {
  const styles = (0, _styles.useStyles)();
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles.wrapper,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    iconType: forward ? 'arrowDown' : 'arrowUp',
    onClick: onClick,
    isLoading: isFetching,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }, text, eventsRemaining > 0 && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.sessionView.processTreeLoadMoreButton",
    defaultMessage: " ({count} left)",
    values: {
      count: eventsRemaining
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement("span", {
    css: styles.dottedLine,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }));
};
exports.ProcessTreeLoadMoreButton = ProcessTreeLoadMoreButton;