"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessTree = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _process_tree_node = require("../process_tree_node");
var _back_to_investigated_alert = require("../back_to_investigated_alert");
var _hooks = require("./hooks");
var _helpers = require("./helpers");
var _process_tree_load_more_button = require("../process_tree_load_more_button");
var _use_scroll = require("../../hooks/use_scroll");
var _styles = require("./styles");
var _constants = require("../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/session_view/public/components/process_tree/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LOAD_NEXT_TEXT = _i18n.i18n.translate('xpack.sessionView.processTree.loadMore', {
  defaultMessage: 'Show {pageSize} next events',
  values: {
    pageSize: _constants.PROCESS_EVENTS_PER_PAGE
  }
});
const LOAD_PREVIOUS_TEXT = _i18n.i18n.translate('xpack.sessionView.processTree.loadPrevious', {
  defaultMessage: 'Show {pageSize} previous events',
  values: {
    pageSize: _constants.PROCESS_EVENTS_PER_PAGE
  }
});
const ProcessTree = ({
  sessionEntityId,
  data,
  jumpToEntityId,
  investigatedAlertId,
  isFetching,
  hasNextPage,
  hasPreviousPage,
  fetchNextPage,
  fetchPreviousPage,
  searchQuery,
  selectedProcess,
  onProcessSelected,
  setSearchResults,
  updatedAlertsStatus,
  onShowAlertDetails,
  onJumpToOutput,
  trackEvent,
  showTimestamp = true,
  verboseMode = false
}) => {
  const [isInvestigatedEventVisible, setIsInvestigatedEventVisible] = (0, _react.useState)(true);
  const [isInvestigatedEventAbove, setIsInvestigatedEventAbove] = (0, _react.useState)(false);
  const styles = (0, _styles.useStyles)();
  const {
    sessionLeader,
    processMap,
    searchResults
  } = (0, _hooks.useProcessTree)({
    sessionEntityId,
    data,
    searchQuery,
    updatedAlertsStatus,
    verboseMode,
    jumpToEntityId
  });
  const [forceRerender, setForceRerender] = (0, _react.useState)(0);
  const eventsRemaining = (0, _react.useMemo)(() => {
    var _data$;
    const total = (data === null || data === void 0 ? void 0 : (_data$ = data[0]) === null || _data$ === void 0 ? void 0 : _data$.total) || 0;
    const loadedSoFar = data.reduce((prev, current) => {
      var _current$events;
      return prev + ((current === null || current === void 0 ? void 0 : (_current$events = current.events) === null || _current$events === void 0 ? void 0 : _current$events.length) || 0);
    }, 0);
    return total - loadedSoFar;
  }, [data]);
  const scrollerRef = (0, _react.useRef)(null);
  const onChangeJumpToEventVisibility = (0, _react.useCallback)((isVisible, isAbove) => {
    if (isVisible !== isInvestigatedEventVisible) {
      setIsInvestigatedEventVisible(isVisible);
    }
    if (!isVisible && isAbove !== isInvestigatedEventAbove) {
      setIsInvestigatedEventAbove(isAbove);
    }
  }, [isInvestigatedEventVisible, isInvestigatedEventAbove]);
  const handleBackToInvestigatedAlert = (0, _react.useCallback)(() => {
    onProcessSelected(null);
    setIsInvestigatedEventVisible(true);
  }, [onProcessSelected]);
  const handleCollapseProcessTree = (0, _react.useCallback)(() => {
    (0, _helpers.collapseProcessTree)(sessionLeader);
    if (scrollerRef.current) {
      scrollerRef.current.scrollTop = 0;
    }
    setForceRerender(Math.random());
    trackEvent('collapse_tree');
  }, [sessionLeader, trackEvent]);
  (0, _react.useEffect)(() => {
    if (setSearchResults) {
      setSearchResults(searchResults);
    }
  }, [searchResults, setSearchResults]);
  (0, _use_scroll.useScroll)({
    div: scrollerRef.current,
    handler: (pos, endReached) => {
      if (!isFetching && endReached) {
        fetchNextPage();
      }
    }
  });
  (0, _react.useEffect)(() => {
    if (jumpToEntityId) {
      const process = processMap[jumpToEntityId];
      const hasDetails = !!(process !== null && process !== void 0 && process.getDetails());
      if (!selectedProcess && hasDetails) {
        onProcessSelected(process);
      }
    } else if (!selectedProcess) {
      onProcessSelected(sessionLeader);
    }
  }, [jumpToEntityId, processMap, onProcessSelected, selectedProcess, sessionLeader]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    ref: scrollerRef,
    css: styles.sessionViewProcessTree,
    "data-test-subj": "sessionView:sessionViewProcessTree",
    key: forceRerender,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 7
    }
  }, sessionLeader && /*#__PURE__*/_react.default.createElement(_process_tree_node.ProcessTreeNode, {
    isSessionLeader: true,
    process: sessionLeader,
    onProcessSelected: onProcessSelected,
    onJumpToOutput: onJumpToOutput,
    jumpToEntityId: jumpToEntityId,
    investigatedAlertId: investigatedAlertId,
    selectedProcess: selectedProcess,
    scrollerRef: scrollerRef,
    onChangeJumpToEventVisibility: onChangeJumpToEventVisibility,
    onShowAlertDetails: onShowAlertDetails,
    showTimestamp: showTimestamp,
    verboseMode: verboseMode,
    searchResults: searchResults,
    handleCollapseProcessTree: handleCollapseProcessTree,
    trackEvent: trackEvent,
    loadPreviousButton: hasPreviousPage ? /*#__PURE__*/_react.default.createElement(_process_tree_load_more_button.ProcessTreeLoadMoreButton, {
      text: LOAD_PREVIOUS_TEXT,
      onClick: fetchPreviousPage,
      isFetching: isFetching,
      eventsRemaining: eventsRemaining,
      forward: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 195,
        columnNumber: 17
      }
    }) : null,
    loadNextButton: hasNextPage ? /*#__PURE__*/_react.default.createElement(_process_tree_load_more_button.ProcessTreeLoadMoreButton, {
      text: LOAD_NEXT_TEXT,
      onClick: fetchNextPage,
      isFetching: isFetching,
      eventsRemaining: eventsRemaining,
      forward: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 206,
        columnNumber: 17
      }
    }) : null,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 11
    }
  })), !isInvestigatedEventVisible && /*#__PURE__*/_react.default.createElement(_back_to_investigated_alert.BackToInvestigatedAlert, {
    onClick: handleBackToInvestigatedAlert,
    isDisplayedAbove: isInvestigatedEventAbove,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 9
    }
  }));
};
exports.ProcessTree = ProcessTree;