"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorIndexNameForm = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _validate_index_name = require("../../../../utils/validate_index_name");
var _use_index_name_search = require("../../../hooks/api/use_index_name_search");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/serverless_search/public/application/components/connectors/connector_config/connector_index_name_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConnectorIndexNameForm = ({
  indexName,
  onChange,
  isDisabled
}) => {
  const [query, setQuery] = (0, _react.useState)('');
  const {
    data: indexNames,
    isLoading: isLoadingIndices,
    refetch
  } = (0, _use_index_name_search.useIndexNameSearch)(query);
  (0, _react.useEffect)(() => {
    refetch();
  }, [query, refetch]);
  const [newIndexName, setNewIndexName] = (0, _react.useState)(indexName);
  (0, _react.useEffect)(() => {
    onChange(newIndexName);
  }, [newIndexName, onChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    error: !(0, _validate_index_name.isValidIndexName)(newIndexName || '') ? _i18n.i18n.translate('xpack.serverlessSearch.connectors.indexNameErrorText', {
      defaultMessage: 'Names should be lowercase and cannot contain spaces or special characters.'
    }) : undefined,
    isInvalid: !!newIndexName && !(0, _validate_index_name.isValidIndexName)(newIndexName),
    label: _i18n.i18n.translate('xpack.serverlessSearch.connectors.config.indexNameLabel', {
      defaultMessage: 'Create or select an index'
    }),
    fullWidth: true,
    helpText: _i18n.i18n.translate('xpack.serverlessSearch.connectors.indexNameInputHelpText', {
      defaultMessage: 'Names should be lowercase and cannot contain spaces or special characters.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    isInvalid: !!newIndexName && !(0, _validate_index_name.isValidIndexName)(newIndexName),
    async: true,
    isClearable: false,
    customOptionText: _i18n.i18n.translate('xpack.serverlessSearch.connectors.config.createIndexLabel', {
      defaultMessage: 'The connector will create the index {searchValue}',
      values: {
        searchValue: '{searchValue}'
      }
    }),
    isDisabled: isDisabled,
    isLoading: isLoadingIndices,
    onChange: values => {
      if (values[0].value) {
        setNewIndexName(values[0].value);
      }
    },
    onCreateOption: value => setNewIndexName(value),
    onSearchChange: value => setQuery(value),
    options: ((indexNames === null || indexNames === void 0 ? void 0 : indexNames.index_names) || []).map(name => ({
      label: name,
      value: name
    })),
    selectedOptions: newIndexName ? [{
      label: newIndexName,
      value: newIndexName
    }] : [],
    singleSelection: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  })));
};
exports.ConnectorIndexNameForm = ConnectorIndexNameForm;