"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorScheduling = void 0;
var _react = _interopRequireWildcard(require("react"));
var _searchConnectors = require("@kbn/search-connectors");
var _connector_scheduling = require("@kbn/search-connectors/components/scheduling/connector_scheduling");
var _use_update_connector_scheduling = require("../../../hooks/api/use_update_connector_scheduling");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/serverless_search/public/application/components/connectors/conector_scheduling_tab/connector_scheduling.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConnectorScheduling = ({
  canManageConnectors,
  connector
}) => {
  var _connector$features$i, _connector$features, _connector$features$i2, _connector$features2, _connector$features2$;
  const [hasChanges, setHasChanges] = (0, _react.useState)(false);
  const {
    isLoading,
    mutate
  } = (0, _use_update_connector_scheduling.useConnectorScheduling)(connector.id);
  const hasIncrementalSyncFeature = (_connector$features$i = connector === null || connector === void 0 ? void 0 : (_connector$features = connector.features) === null || _connector$features === void 0 ? void 0 : _connector$features.incremental_sync) !== null && _connector$features$i !== void 0 ? _connector$features$i : false;
  const shouldShowIncrementalSync = hasIncrementalSyncFeature && ((_connector$features$i2 = connector === null || connector === void 0 ? void 0 : (_connector$features2 = connector.features) === null || _connector$features2 === void 0 ? void 0 : (_connector$features2$ = _connector$features2.incremental_sync) === null || _connector$features2$ === void 0 ? void 0 : _connector$features2$.enabled) !== null && _connector$features$i2 !== void 0 ? _connector$features$i2 : false);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_connector_scheduling.ConnectorSchedulingComponent, {
    connector: connector,
    isDisabled: !canManageConnectors,
    dataTelemetryIdPrefix: "serverlessSearch",
    hasChanges: hasChanges,
    hasIngestionError: (connector === null || connector === void 0 ? void 0 : connector.status) === _searchConnectors.ConnectorStatus.ERROR,
    hasPlatinumLicense: false,
    setHasChanges: setHasChanges,
    shouldShowAccessControlSync: false,
    shouldShowIncrementalSync: shouldShowIncrementalSync,
    updateConnectorStatus: isLoading,
    updateScheduling: mutate,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 7
    }
  }));
};
exports.ConnectorScheduling = ConnectorScheduling;