"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.docLinks = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ESDocLinks {
  constructor() {
    (0, _defineProperty2.default)(this, "apiIntro", '');
    (0, _defineProperty2.default)(this, "beats", '');
    (0, _defineProperty2.default)(this, "integrations", '');
    (0, _defineProperty2.default)(this, "kibanaFeedback", '');
    (0, _defineProperty2.default)(this, "kibanaRunApiInConsole", '');
    (0, _defineProperty2.default)(this, "logstash", '');
    (0, _defineProperty2.default)(this, "metadata", '');
    (0, _defineProperty2.default)(this, "roleDescriptors", '');
    (0, _defineProperty2.default)(this, "securityApis", '');
    (0, _defineProperty2.default)(this, "ingestionPipelines", '');
    (0, _defineProperty2.default)(this, "dataStreams", '');
    // Connectors links
    (0, _defineProperty2.default)(this, "connectors", '');
    (0, _defineProperty2.default)(this, "connectorClientAvailableConnectors", '');
    (0, _defineProperty2.default)(this, "connectorsRunFromSource", '');
    (0, _defineProperty2.default)(this, "connectorsRunWithDocker", '');
    // Client links
    (0, _defineProperty2.default)(this, "elasticsearchClients", '');
    // go
    (0, _defineProperty2.default)(this, "goApiReference", undefined);
    (0, _defineProperty2.default)(this, "goBasicConfig", '');
    (0, _defineProperty2.default)(this, "goClient", '');
    // javascript
    (0, _defineProperty2.default)(this, "jsApiReference", '');
    (0, _defineProperty2.default)(this, "jsBasicConfig", '');
    (0, _defineProperty2.default)(this, "jsClient", '');
    // php
    (0, _defineProperty2.default)(this, "phpApiReference", undefined);
    (0, _defineProperty2.default)(this, "phpBasicConfig", '');
    (0, _defineProperty2.default)(this, "phpClient", '');
    // python
    (0, _defineProperty2.default)(this, "pythonApiReference", undefined);
    (0, _defineProperty2.default)(this, "pythonBasicConfig", '');
    (0, _defineProperty2.default)(this, "pythonClient", '');
    // ruby
    (0, _defineProperty2.default)(this, "rubyBasicConfig", '');
    (0, _defineProperty2.default)(this, "rubyClient", '');
    (0, _defineProperty2.default)(this, "rubyExamples", '');
    // Getting Started
    (0, _defineProperty2.default)(this, "gettingStartedIngest", '');
    (0, _defineProperty2.default)(this, "gettingStartedSearch", '');
    (0, _defineProperty2.default)(this, "gettingStartedExplore", '');
    // Ingest processor
    (0, _defineProperty2.default)(this, "dataEnrichment", '');
    (0, _defineProperty2.default)(this, "dataFiltering", '');
    (0, _defineProperty2.default)(this, "arrayOrJson", '');
    (0, _defineProperty2.default)(this, "dataTransformation", '');
    (0, _defineProperty2.default)(this, "pipelineHandling", '');
    (0, _defineProperty2.default)(this, "pipelines", '');
  }
  setDocLinks(newDocLinks) {
    this.apiIntro = newDocLinks.serverlessClients.httpApis;
    this.integrations = newDocLinks.serverlessSearch.integrations;
    this.logstash = newDocLinks.serverlessSearch.integrationsLogstash;
    this.beats = newDocLinks.serverlessSearch.integrationsBeats;
    this.kibanaFeedback = newDocLinks.kibana.feedback;
    this.kibanaRunApiInConsole = newDocLinks.console.guide;
    this.metadata = newDocLinks.security.mappingRoles;
    this.roleDescriptors = newDocLinks.serverlessSecurity.apiKeyPrivileges;
    this.securityApis = newDocLinks.apis.securityApis;
    this.ingestionPipelines = newDocLinks.ingest.pipelines;
    this.dataStreams = newDocLinks.elasticsearch.dataStreams;

    // Connectors links
    this.connectors = newDocLinks.serverlessSearch.integrationsConnectorClient;
    this.connectorClientAvailableConnectors = newDocLinks.serverlessSearch.integrationsConnectorClientAvailableConnectors;
    this.connectorsRunFromSource = newDocLinks.serverlessSearch.integrationsConnectorClientRunFromSource;
    this.connectorsRunWithDocker = newDocLinks.serverlessSearch.integrationsConnectorClientRunWithDocker;

    // Client links
    this.elasticsearchClients = newDocLinks.serverlessClients.clientLib;
    // Go
    this.goApiReference = newDocLinks.serverlessClients.goApiReference;
    this.goBasicConfig = newDocLinks.serverlessClients.goGettingStarted;
    this.goClient = newDocLinks.serverlessClients.goGettingStarted;
    // JS
    this.jsApiReference = newDocLinks.serverlessClients.jsApiReference;
    this.jsBasicConfig = newDocLinks.serverlessClients.jsGettingStarted;
    this.jsClient = newDocLinks.serverlessClients.jsGettingStarted;
    // PHP
    this.phpApiReference = newDocLinks.serverlessClients.phpApiReference;
    this.phpBasicConfig = newDocLinks.serverlessClients.phpGettingStarted;
    this.phpClient = newDocLinks.serverlessClients.phpGettingStarted;
    // Python
    this.pythonApiReference = newDocLinks.serverlessClients.pythonGettingStarted;
    this.pythonBasicConfig = newDocLinks.serverlessClients.pythonGettingStarted;
    this.pythonClient = newDocLinks.serverlessClients.pythonGettingStarted;
    // Ruby
    this.rubyBasicConfig = newDocLinks.serverlessClients.rubyGettingStarted;
    this.rubyExamples = newDocLinks.serverlessClients.rubyApiReference;
    this.rubyClient = newDocLinks.serverlessClients.rubyGettingStarted;

    // Getting Started
    this.gettingStartedIngest = newDocLinks.serverlessSearch.gettingStartedIngest;
    this.gettingStartedSearch = newDocLinks.serverlessSearch.gettingStartedSearch;
    this.gettingStartedExplore = newDocLinks.serverlessSearch.gettingStartedExplore;

    // Ingest processor
    this.dataEnrichment = newDocLinks.ingest.dataEnrichment;
    this.dataFiltering = newDocLinks.ingest.dataFiltering;
    this.arrayOrJson = newDocLinks.ingest.arrayOrJson;
    this.dataTransformation = newDocLinks.ingest.dataTransformation;
    this.pipelineHandling = newDocLinks.ingest.pipelineHandling;
    this.pipelines = newDocLinks.ingest.pipelines;
  }
}
const docLinks = exports.docLinks = new ESDocLinks();