"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseEndpoint = parseEndpoint;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const validMethods = ['delete', 'get', 'patch', 'post', 'put'];
function parseEndpoint(endpoint) {
  var _parts$;
  const parts = endpoint.split(' ');
  const method = parts[0].trim().toLowerCase();
  const pathname = parts[1].trim();
  const version = (_parts$ = parts[2]) === null || _parts$ === void 0 ? void 0 : _parts$.trim();
  if (!validMethods.includes(method)) {
    throw new Error(`Endpoint ${endpoint} was not prefixed with a valid HTTP method`);
  }
  return {
    method,
    pathname,
    version
  };
}