"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FindExceptionListsResponse = exports.FindExceptionListsRequestQuery = exports.FindExceptionListsFilter = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _exception_list_common = require("../model/exception_list_common.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Find exception lists API endpoint
 *   version: 2023-10-31
 */

const FindExceptionListsFilter = exports.FindExceptionListsFilter = _zod.z.string();
const FindExceptionListsRequestQuery = exports.FindExceptionListsRequestQuery = _zod.z.object({
  /** 
      * Filters the returned results according to the value of the specified field.
  Uses the `so type.field name:field` value syntax, where `so type` can be:
  - `exception-list`: Specify a space-aware exception list.
  - `exception-list-agnostic`: Specify an exception list that is shared across spaces.
        */
  filter: FindExceptionListsFilter.optional(),
  /** 
      * Determines whether the returned containers are Kibana associated with a Kibana space
  or available in all spaces (`agnostic` or `single`)
        */
  namespace_type: (0, _zodHelpers.ArrayFromString)(_exception_list_common.ExceptionNamespaceType).optional().default(['single']),
  /**
   * The page number to return
   */
  page: _zod.z.coerce.number().int().min(1).optional(),
  /**
   * The number of exception lists to return per page
   */
  per_page: _zod.z.coerce.number().int().min(1).optional(),
  /**
   * Determines which field is used to sort the results.
   */
  sort_field: _zod.z.string().optional(),
  /**
   * Determines the sort order, which can be `desc` or `asc`.
   */
  sort_order: _zod.z.enum(['desc', 'asc']).optional()
});
const FindExceptionListsResponse = exports.FindExceptionListsResponse = _zod.z.object({
  data: _zod.z.array(_exception_list_common.ExceptionList),
  page: _zod.z.number().int().min(1),
  per_page: _zod.z.number().int().min(1),
  total: _zod.z.number().int().min(0)
});