"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addEndpointExceptionsToReadAndAll = addEndpointExceptionsToReadAndAll;
exports.addGlobalArtifactManagementToAll = addGlobalArtifactManagementToAll;
exports.enableSecuritySubfeaturesToggle = enableSecuritySubfeaturesToggle;
exports.productFeaturesExtensions = void 0;
var _keys = require("@kbn/security-solution-features/keys");
var _common = require("@kbn/security-solution-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const productFeaturesExtensions = exports.productFeaturesExtensions = {
  security: {
    allVersions: {},
    version: {
      siem: {
        [_keys.ProductFeatureSecurityKey.endpointArtifactManagement]: {
          featureConfigModifiers: [enableSecuritySubfeaturesToggle, addGlobalArtifactManagementToAll]
        },
        [_keys.ProductFeatureSecurityKey.endpointExceptions]: {
          featureConfigModifiers: [enableSecuritySubfeaturesToggle, addEndpointExceptionsToReadAndAll],
          // On Serverless, endpoint exception was a sub-feature privilege, but was included in security 'read' and 'all'.
          // Using `includeIn` here will provide backwards compatibility, without adding endpoint exceptions api privileges
          // to security 'minimal_read' and 'minimal_all'.
          subFeaturesPrivileges: [{
            id: 'endpoint_exceptions_all',
            includeIn: 'all'
          }, {
            id: 'endpoint_exceptions_read',
            includeIn: 'read'
          }]
        }
      },
      siemV2: {
        [_keys.ProductFeatureSecurityKey.endpointArtifactManagement]: {
          featureConfigModifiers: [enableSecuritySubfeaturesToggle, addGlobalArtifactManagementToAll]
        },
        [_keys.ProductFeatureSecurityKey.endpointExceptions]: {
          featureConfigModifiers: [enableSecuritySubfeaturesToggle, addEndpointExceptionsToReadAndAll],
          subFeaturesPrivileges: [{
            id: 'endpoint_exceptions_all',
            includeIn: 'all'
          }, {
            id: 'endpoint_exceptions_read',
            includeIn: 'read'
          }]
        }
      },
      siemV3: {
        [_keys.ProductFeatureSecurityKey.endpointExceptions]: {
          featureConfigModifiers: [enableSecuritySubfeaturesToggle, addEndpointExceptionsToReadAndAll],
          subFeaturesPrivileges: [{
            id: 'endpoint_exceptions_all',
            includeIn: 'all'
          }, {
            id: 'endpoint_exceptions_read',
            includeIn: 'read'
          }]
        }
      }
    }
  }
};

// When endpointArtifactManagement PLI is enabled, the replacedBy to the SIEM feature needs to
// account for the privileges of the additional sub-features that it introduces, migrating them correctly.
// This needs to be done here because some the replacements of serverless and ESS are different, other
// replacements are tied to endpointArtifactManagement PLI - hence PLI related privileges cannot be added to
// the shared base config in `kibana_features.ts`.
function addGlobalArtifactManagementToAll(featureConfig) {
  var _featureConfig$privil, _featureConfig$privil2;
  const allReplacedBy = (_featureConfig$privil = featureConfig.privileges) === null || _featureConfig$privil === void 0 ? void 0 : (_featureConfig$privil2 = _featureConfig$privil.all) === null || _featureConfig$privil2 === void 0 ? void 0 : _featureConfig$privil2.replacedBy;
  if (allReplacedBy && 'default' in allReplacedBy) {
    const siemAll = allReplacedBy.default.find(({
      feature
    }) => feature === _common.SECURITY_FEATURE_ID);

    // on ESS, Endpoint Exception ALL is included in siem:ALL, hence we're adding global artifact management to preserve behaviour
    siemAll === null || siemAll === void 0 ? void 0 : siemAll.privileges.push('global_artifact_management_all');
  }
}

// When Endpoint Exceptions sub-feature privilege is harmonized between ESS and Serverless (from siemV4),
// the privileges needed to be added to users with specific security privileges.
// On ESS, Endpoint exceptions were included in siem:MINIMAL_READ and siem:MINIMAL_ALL.
function addEndpointExceptionsToReadAndAll(featureConfig) {
  var _featureConfig$privil3, _featureConfig$privil4, _featureConfig$privil5, _featureConfig$privil6;
  const readReplacedBy = (_featureConfig$privil3 = featureConfig.privileges) === null || _featureConfig$privil3 === void 0 ? void 0 : (_featureConfig$privil4 = _featureConfig$privil3.read) === null || _featureConfig$privil4 === void 0 ? void 0 : _featureConfig$privil4.replacedBy;
  if (readReplacedBy && 'default' in readReplacedBy) {
    const siemRead = readReplacedBy.default.find(({
      feature
    }) => feature === _common.SECURITY_FEATURE_ID);
    siemRead === null || siemRead === void 0 ? void 0 : siemRead.privileges.push('endpoint_exceptions_read');
  }
  const allReplacedBy = (_featureConfig$privil5 = featureConfig.privileges) === null || _featureConfig$privil5 === void 0 ? void 0 : (_featureConfig$privil6 = _featureConfig$privil5.all) === null || _featureConfig$privil6 === void 0 ? void 0 : _featureConfig$privil6.replacedBy;
  if (allReplacedBy && 'default' in allReplacedBy) {
    const siemAll = allReplacedBy.default.find(({
      feature
    }) => feature === _common.SECURITY_FEATURE_ID);
    siemAll === null || siemAll === void 0 ? void 0 : siemAll.privileges.push('endpoint_exceptions_all');
  }
}
function enableSecuritySubfeaturesToggle(featureConfig) {
  var _featureConfig$privil7, _featureConfig$privil8, _featureConfig$privil9, _featureConfig$privil10;
  const readReplacedBy = (_featureConfig$privil7 = featureConfig.privileges) === null || _featureConfig$privil7 === void 0 ? void 0 : (_featureConfig$privil8 = _featureConfig$privil7.read) === null || _featureConfig$privil8 === void 0 ? void 0 : _featureConfig$privil8.replacedBy;
  if (readReplacedBy && 'default' in readReplacedBy) {
    const siemRead = readReplacedBy.default.find(({
      feature
    }) => feature === _common.SECURITY_FEATURE_ID);
    if (siemRead) {
      siemRead.privileges = siemRead.privileges.map(privilege => privilege === 'read' ? 'minimal_read' : privilege);
    }
  }
  const allReplacedBy = (_featureConfig$privil9 = featureConfig.privileges) === null || _featureConfig$privil9 === void 0 ? void 0 : (_featureConfig$privil10 = _featureConfig$privil9.all) === null || _featureConfig$privil10 === void 0 ? void 0 : _featureConfig$privil10.replacedBy;
  if (allReplacedBy && 'default' in allReplacedBy) {
    const siemAll = allReplacedBy.default.find(({
      feature
    }) => feature === _common.SECURITY_FEATURE_ID);
    if (siemAll) {
      siemAll.privileges = siemAll.privileges.map(privilege => privilege === 'all' ? 'minimal_all' : privilege);
    }
  }
}