"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildActionResultsQuery = void 0;
var _constants = require("../../../../../../common/endpoint/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildActionResultsQuery = ({
  actionId,
  sort
}) => {
  const fields = [{
    field: '*'
  }, {
    field: 'EndpointActions.*',
    include_unmapped: true
  }];
  const dslQuery = {
    allow_no_indices: true,
    index: [_constants.ENDPOINT_ACTION_RESPONSES_INDEX],
    fields,
    _source: false,
    size: 1,
    query: {
      term: {
        action_id: actionId
      }
    },
    aggs: {
      aggs: {
        global: {},
        aggs: {
          responses_by_action_id: {
            filter: {
              bool: {
                must: [{
                  match: {
                    action_id: actionId
                  }
                }]
              }
            },
            aggs: {
              responses: {
                terms: {
                  script: {
                    lang: 'painless',
                    source: "if (doc.containsKey('error.code') && doc['error.code'].size()==0) { return 'success' } else { return 'error' }"
                  }
                }
              }
            }
          }
        }
      }
    },
    sort: [{
      [sort.field]: {
        order: sort.order
      }
    }]
  };
  return dslQuery;
};
exports.buildActionResultsQuery = buildActionResultsQuery;