"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timelineSavedObjectTypes = exports.savedObjectTypesWithoutTimelineAndWithoutNotes = exports.savedObjectTypes = exports.notesSavedObjectTypes = exports.initSavedObjects = exports.initEncryptedSavedObjects = void 0;
var _securityAiPrompts = require("@kbn/security-ai-prompts");
var _reference_data = require("./endpoint/lib/reference_data");
var _saved_object_mappings = require("./endpoint/lib/protection_updates_note/saved_object_mappings");
var _saved_object_mappings2 = require("./lib/timeline/saved_object_mappings");
var _rule_actions_legacy = require("./lib/detection_engine/rule_actions_legacy");
var _prebuilt_rules = require("./lib/detection_engine/prebuilt_rules");
var _saved_objects = require("./lib/detection_engine/migrations/saved_objects");
var _saved_object_mappings3 = require("./endpoint/lib/artifacts/saved_object_mappings");
var _saved_object = require("./lib/entity_analytics/risk_engine/saved_object");
var _saved_object2 = require("./lib/entity_analytics/entity_store/saved_object");
var _saved_objects2 = require("./lib/entity_analytics/privilege_monitoring/saved_objects");
var _saved_object3 = require("./lib/entity_analytics/privilege_monitoring/auth/saved_object");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line no-restricted-imports

const types = [_saved_object_mappings2.noteType, _saved_object_mappings2.pinnedEventType, _rule_actions_legacy.legacyType, _prebuilt_rules.prebuiltRuleAssetType, _saved_object_mappings2.timelineType, _saved_object_mappings3.manifestType, _saved_object_mappings3.unifiedManifestType, _saved_objects.type, _saved_object.riskEngineConfigurationType, _saved_object2.entityEngineDescriptorType, _saved_objects2.privilegeMonitoringType, _saved_object3.PrivilegeMonitoringApiKeyType, _saved_objects2.monitoringEntitySourceType, _saved_object_mappings.protectionUpdatesNoteType, _securityAiPrompts.promptType, _reference_data.referenceDataSavedObjectType];
const savedObjectTypes = exports.savedObjectTypes = types.map(type => type.name);
const savedObjectTypesWithoutTimelineAndWithoutNotes = exports.savedObjectTypesWithoutTimelineAndWithoutNotes = savedObjectTypes.filter(type => {
  switch (type) {
    case _saved_object_mappings2.noteType.name:
    case _saved_object_mappings2.pinnedEventType.name:
    case _saved_object_mappings2.timelineType.name:
      return false;
    default:
      return true;
  }
});
const timelineSavedObjectTypes = exports.timelineSavedObjectTypes = [_saved_object_mappings2.timelineType.name, _saved_object_mappings2.pinnedEventType.name];
const notesSavedObjectTypes = exports.notesSavedObjectTypes = [_saved_object_mappings2.noteType.name];
const initSavedObjects = savedObjects => {
  types.forEach(type => savedObjects.registerType(type));
};
exports.initSavedObjects = initSavedObjects;
const initEncryptedSavedObjects = ({
  encryptedSavedObjects,
  logger
}) => {
  if (!encryptedSavedObjects) {
    logger.warn('EncryptedSavedObjects plugin not available; skipping registration.');
    return;
  }
  encryptedSavedObjects.registerType(_saved_object3.PrivilegeMonitoringApiKeyEncryptionParams);
};
exports.initEncryptedSavedObjects = initEncryptedSavedObjects;