"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SiemRuleMigrationsService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _assert = _interopRequireDefault(require("assert"));
var _rule_migrations_data_service = require("./data/rule_migrations_data_service");
var _rule_migrations_task_service = require("./task/rule_migrations_task_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SiemRuleMigrationsService {
  constructor(logger, kibanaVersion, elserInferenceId) {
    (0, _defineProperty2.default)(this, "dataService", void 0);
    (0, _defineProperty2.default)(this, "esClusterClient", void 0);
    (0, _defineProperty2.default)(this, "taskService", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.logger = logger.get('siemRuleMigrations');
    this.dataService = new _rule_migrations_data_service.RuleMigrationsDataService(this.logger, kibanaVersion, elserInferenceId);
    this.taskService = new _rule_migrations_task_service.RuleMigrationsTaskService(this.logger);
  }
  setup({
    esClusterClient,
    ...params
  }) {
    this.esClusterClient = esClusterClient;
    const esClient = esClusterClient.asInternalUser;
    this.dataService.setup({
      ...params,
      esClient
    }).catch(err => {
      this.logger.error('Error installing data service.', err);
    });
  }
  createClient({
    request,
    currentUser,
    spaceId,
    dependencies
  }) {
    (0, _assert.default)(currentUser, 'Current user must be authenticated');
    (0, _assert.default)(this.esClusterClient, 'ES client not available, please call setup first');
    const esScopedClient = this.esClusterClient.asScoped(request);
    const dataClient = this.dataService.createClient({
      spaceId,
      currentUser,
      esScopedClient,
      dependencies
    });
    const taskClient = this.taskService.createClient({
      request,
      currentUser,
      dataClient,
      dependencies
    });
    return {
      data: dataClient,
      task: taskClient
    };
  }
  stop() {
    this.taskService.stopAll();
  }
}
exports.SiemRuleMigrationsService = SiemRuleMigrationsService;